/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;

public final class DatasourceConnectionPool
implements ConnectionPool {
    private final DataSource dataSource;
    private AtomicBoolean isClosed = new AtomicBoolean();

    public DatasourceConnectionPool(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Connection get() {
        if (this.isClosed.get()) {
            throw new CelestaException("ConnectionPool is closed");
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            CelestaException celestaException = new CelestaException("Could not connect to the database with error: %s", e.getMessage());
            celestaException.initCause(e);
            throw celestaException;
        }
    }

    @Override
    public void setDbAdaptor(DBAdaptor dbAdaptor) {
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true) && this.dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            catch (Exception e) {
                throw new CelestaException(e);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }
}

