/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public final class BLOB
implements Cloneable {
    private DataPage data;
    private boolean isModified;
    private int size;

    public BLOB() {
    }

    BLOB(final InputStream source) throws IOException {
        InputStream counter = new InputStream(){

            @Override
            public int read() throws IOException {
                int result = source.read();
                if (result >= 0) {
                    BLOB.this.size++;
                }
                return result;
            }
        };
        int buf = counter.read();
        this.data = buf < 0 ? new DataPage(0) : new DataPage(buf, counter);
    }

    public BLOB clone() {
        BLOB result = new BLOB();
        result.data = this.data;
        result.size = this.size;
        return result;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public InputStream getInStream() {
        return this.data == null ? null : this.data.getInStream();
    }

    public OutputStream getOutStream() {
        this.isModified = true;
        this.data = new DataPage();
        this.size = 0;
        return new OutputStream(){
            private DataPage tail;
            {
                this.tail = BLOB.this.data;
            }

            @Override
            public void write(int b) {
                this.tail = this.tail.write(b);
                BLOB.this.size++;
            }
        };
    }

    void saveToJDBCBlob(Blob b) throws SQLException {
        DataPage currPage = this.data;
        int i = 1;
        while (currPage != null && currPage.pos == currPage.data.length) {
            i += b.setBytes(i, currPage.data);
            currPage = currPage.nextPage;
        }
        if (currPage != null) {
            b.setBytes(i, currPage.data, 0, currPage.pos);
        }
    }

    public boolean isNull() {
        return this.data == null;
    }

    public void setNull() {
        this.isModified = this.isModified || this.data != null;
        this.size = 0;
        this.data = null;
    }

    public int size() {
        return this.size;
    }

    private static final class DataPage {
        private static final int DEFAULT_PAGE_SIZE = 65535;
        private static final int BYTE_MASK = 255;
        private final byte[] data;
        private DataPage nextPage;
        private int pos;

        DataPage() {
            this(65535);
        }

        private DataPage(int size) {
            this.data = new byte[size];
        }

        private DataPage(int firstByte, InputStream source) throws IOException {
            this();
            int buf = firstByte;
            while (this.pos < this.data.length && buf >= 0) {
                this.data[this.pos++] = (byte)buf;
                buf = source.read();
            }
            this.nextPage = buf < 0 ? null : new DataPage(buf, source);
        }

        DataPage write(int b) {
            DataPage result;
            if (this.pos < this.data.length) {
                this.data[this.pos++] = (byte)(b & 0xFF);
                return this;
            }
            this.nextPage = result = new DataPage();
            return result.write(b);
        }

        InputStream getInStream() {
            return new InputStream(){
                private int i = 0;
                private DataPage currentPage = this;

                @Override
                public int read() {
                    if (this.i < this.currentPage.pos) {
                        return this.currentPage.data[this.i++] & 0xFF;
                    }
                    if (this.currentPage.nextPage != null) {
                        this.i = 0;
                        this.currentPage = this.currentPage.nextPage;
                        return this.read();
                    }
                    return -1;
                }
            };
        }
    }
}

