/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ICallContext;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.score.GrainElement;

public abstract class CsqlBasicDataAccessor<T extends ICallContext>
implements Closeable {
    protected static final String DATA_ACCESSOR_IS_CLOSED = "DataAccessor is closed.";
    private final T context;
    private final Connection conn;
    private final DBAdaptor db;
    private boolean closed = false;

    public CsqlBasicDataAccessor(T context) {
        this.validateInitContext(context);
        this.context = context;
        this.conn = context.getConn();
        try {
            if (this.conn.isClosed()) {
                throw new CelestaException("Trying to create a cursor on closed connection.");
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        this.db = this.callContext().getDbAdaptor();
    }

    protected void validateInitContext(T context) {
        if (context == null) {
            throw new CelestaException("Invalid context passed to %s constructor: context should not be null.", this.getClass().getName());
        }
        if (context.getConn() == null) {
            throw new CelestaException("Invalid context passed to %s constructor: connection is null.", this.getClass().getName());
        }
        if (context.isClosed()) {
            throw new CelestaException("Cannot create %s on a closed CallContext.", this.getClass().getName());
        }
    }

    public final T callContext() {
        return this.context;
    }

    protected final DBAdaptor db() {
        return this.db;
    }

    protected final Connection conn() {
        return this.conn;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void close() {
        if (!this.isClosed()) {
            this.closed = true;
            this.closeInternal();
        }
    }

    protected abstract void closeInternal();

    public abstract void clear();

    public abstract GrainElement meta();
}

