/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import java.text.SimpleDateFormat;
import ru.curs.celesta.dbutils.adaptors.column.FireBirdColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;

class FireBirdDateTimeColumnDefiner
extends FireBirdColumnDefiner {
    FireBirdDateTimeColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "timestamp";
    }

    @Override
    public String getInternalDefinition(Column c) {
        return FireBirdDateTimeColumnDefiner.join(c.getQuotedName(), this.dbFieldType());
    }

    public String getDefaultDefinition(Column c) {
        DateTimeColumn ic = (DateTimeColumn)c;
        String defaultStr = "";
        if (ic.isGetdate()) {
            defaultStr = "default current_timestamp";
        } else if (ic.getDefaultValue() != null) {
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
            defaultStr = String.format("default  '%s'", df.format(ic.getDefaultValue()));
        }
        return defaultStr;
    }
}

