/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import java.text.SimpleDateFormat;
import ru.curs.celesta.dbutils.adaptors.column.MsSqlColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;

class MsSqlDateTimeColumnDefiner
extends MsSqlColumnDefiner {
    MsSqlDateTimeColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "datetime";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        return MsSqlDateTimeColumnDefiner.join(c.getQuotedName(), this.dbFieldType(), this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        DateTimeColumn ic = (DateTimeColumn)c;
        String defaultStr = "";
        if (ic.isGetdate()) {
            defaultStr = this.msSQLDefault(c) + "getdate()";
        } else if (ic.getDefaultValue() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            defaultStr = String.format(this.msSQLDefault(c) + " '%s'", df.format(ic.getDefaultValue()));
        }
        return defaultStr;
    }

    @Override
    public String getLightDefaultDefinition(Column<?> c) {
        DateTimeColumn ic = (DateTimeColumn)c;
        String defaultStr = "";
        if (ic.isGetdate()) {
            defaultStr = "default getdate()";
        } else if (ic.getDefaultValue() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            defaultStr = String.format("default  '%s'", df.format(ic.getDefaultValue()));
        }
        return defaultStr;
    }
}

