/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.OraColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.StringColumn;

class OraStringColumnDefiner
extends OraColumnDefiner {
    OraStringColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "nvarchar2";
    }

    @Override
    public String nullable(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        return "".equals(ic.getDefaultValue()) ? "null" : super.nullable(c);
    }

    @Override
    public String getInternalDefinition(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        String fieldType = ic.isMax() ? "nclob" : String.format("%s(%s)", this.dbFieldType(), ic.getLength());
        return OraStringColumnDefiner.join(c.getQuotedName(), fieldType);
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = "default " + StringColumn.quoteString(ic.getDefaultValue());
        }
        return defaultStr;
    }
}

