/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.ddl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefinerFactory;
import ru.curs.celesta.dbutils.adaptors.column.OraColumnDefiner;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.function.CommonFunctions;
import ru.curs.celesta.dbutils.adaptors.function.OraFunctions;
import ru.curs.celesta.dbutils.adaptors.function.SchemalessFunctions;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.Parameter;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Sum;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.VersionedElement;
import ru.curs.celesta.score.ViewColumnMeta;

public final class OraDdlGenerator
extends DdlGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OraDdlGenerator.class);

    public OraDdlGenerator(DBAdaptor dmlAdaptor) {
        super(dmlAdaptor);
    }

    @Override
    Optional<String> createSchema(String name) {
        return Optional.empty();
    }

    @Override
    List<String> dropParameterizedView(String schemaName, String viewName, Connection conn) {
        String objectTypeName;
        ArrayList<String> result = new ArrayList<String>();
        String dropFunction = String.format("DROP FUNCTION %s", this.tableString(schemaName, viewName));
        result.add(dropFunction);
        String tableTypeName = String.format("%s_%s_t", schemaName, viewName);
        if (this.hasTypeInteractive(tableTypeName, "COLLECTION", conn)) {
            result.add(this.dropType(tableTypeName));
        }
        if (this.hasTypeInteractive(objectTypeName = String.format("%s_%s_o", schemaName, viewName), "OBJECT", conn)) {
            result.add(this.dropType(objectTypeName));
        }
        return result;
    }

    @Override
    List<String> dropIndex(Grain g, DbIndexInfo dBIndexInfo) {
        String sql = dBIndexInfo.getIndexName().startsWith("##") ? this.dropIndex(dBIndexInfo.getIndexName().substring(2)) : this.dropIndex(this.tableString(g.getName(), dBIndexInfo.getIndexName()));
        return Arrays.asList(sql);
    }

    @Override
    List<String> dropUpdateRule(String fkName) {
        ArrayList<String> result = new ArrayList<String>();
        TriggerQuery triggerQuery = new TriggerQuery();
        triggerQuery.withName(OraDdlGenerator.getFKTriggerName("snl_", fkName));
        result.add(this.dropTriggerSql(triggerQuery));
        triggerQuery.withName(OraDdlGenerator.getFKTriggerName("csc_", fkName));
        result.add(this.dropTrigger(triggerQuery));
        return result;
    }

    private static String getFKTriggerName(String prefix, String fkName) {
        String result = prefix + fkName;
        result = NamedElement.limitName(result);
        return result;
    }

    @Override
    String dropTriggerSql(TriggerQuery query) {
        String sql = String.format("drop trigger \"%s\"", query.getName());
        return sql;
    }

    private String dropIndex(String indexFullName) {
        return String.format("DROP INDEX %s", indexFullName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasTypeInteractive(String typeName, String typeCode, Connection conn) {
        String sql = String.format("SELECT TYPE_NAME from DBA_TYPES WHERE owner = sys_context('userenv','session_user')\n and TYPECODE = '%s' and TYPE_NAME = '%s'", typeCode, typeName);
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new CelestaException(e);
        }
    }

    private String dropType(String typeName) {
        return String.format("DROP TYPE \"%s\"", typeName);
    }

    @Override
    String generateArgumentsForCreateSequenceExpression(SequenceElement s, SequenceElement.Argument ... excludedArguments) {
        String result = super.generateArgumentsForCreateSequenceExpression(s, excludedArguments);
        if (s.hasArgument(SequenceElement.Argument.CYCLE)) {
            result = result + " NOCACHE";
        }
        return result;
    }

    @Override
    DBType getType() {
        return DBType.ORACLE;
    }

    @Override
    List<String> updateVersioningTrigger(Connection conn, TableElement t) {
        ArrayList<String> result = new ArrayList<String>();
        String triggerName = SchemalessFunctions.getUpdTriggerName(t);
        try {
            TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withName(triggerName).withTableName(t.getName()).withType(TriggerType.PRE_UPDATE);
            boolean triggerExists = this.triggerExists(conn, query);
            if (t instanceof VersionedElement) {
                VersionedElement ve = (VersionedElement)((Object)t);
                if (ve.isVersioned()) {
                    if (!triggerExists) {
                        String sql = String.format("CREATE OR REPLACE TRIGGER \"%s\" BEFORE UPDATE ON \"%s_%s\" FOR EACH ROW\nBEGIN\n  IF :new.\"recversion\" <> :old.\"recversion\" THEN\n    raise_application_error( -20001, 'record version check failure' );\n  END IF;\n  :new.\"recversion\" := :new.\"recversion\" + 1;\nEND;", triggerName, t.getGrain().getName(), t.getName());
                        LOGGER.trace(sql);
                        result.add(sql);
                        this.rememberTrigger(query);
                    }
                } else if (triggerExists) {
                    TriggerQuery dropQuery = new TriggerQuery().withName(triggerName);
                    result.add(this.dropTrigger(dropQuery));
                }
            }
        }
        catch (CelestaException e) {
            throw new CelestaException("Could not update version check trigger on %s.%s: %s", t.getGrain().getName(), t.getName(), e.getMessage());
        }
        return result;
    }

    @Override
    List<String> afterCreateTable(Connection conn, TableElement t) {
        ArrayList<String> result = new ArrayList<String>();
        for (Column<?> column : t.getColumns().values()) {
            IntegerColumn ic;
            if (!IntegerColumn.class.equals(column.getClass()) || (ic = (IntegerColumn)column).getSequence() == null) continue;
            SequenceElement s = ic.getSequence();
            String triggerName = SchemalessFunctions.generateSequenceTriggerName(ic);
            String sequenceName = this.sequenceString(s.getGrain().getName(), s.getName());
            String sql = this.createOrReplaceSequenceTriggerForColumn(triggerName, ic, sequenceName);
            result.add(sql);
            TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName()).withName(triggerName);
            this.rememberTrigger(query);
        }
        return result;
    }

    @Override
    public String dropPk(TableElement t, String pkName) {
        String sql = String.format("alter table \"%s_%s\" drop constraint \"%s\"", t.getGrain().getName(), t.getName(), pkName);
        return sql;
    }

    @Override
    List<String> updateColumn(Connection conn, Column<?> c, DbColumnInfo actual) {
        Class<?> cClass = c.getClass();
        ArrayList<String> result = new ArrayList<String>();
        String tableFullName = this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName());
        TableElement t = c.getParentTable();
        String triggerName = SchemalessFunctions.getUpdTriggerName(t);
        TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withName(triggerName).withTableName(t.getName()).withType(TriggerType.PRE_UPDATE);
        boolean triggerExists = this.triggerExists(conn, query);
        if (triggerExists) {
            result.add(this.dropTrigger(query));
        }
        if (actual.getType() == BooleanColumn.class && !(c instanceof BooleanColumn)) {
            String sql = String.format("alter table " + tableFullName + " drop constraint %s", OraFunctions.getBooleanCheckName(c));
            result.add(sql);
        }
        OraColumnDefiner definer = (OraColumnDefiner)ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass);
        String defdef = this.defaultDefForAlter(c, definer, actual);
        String def = actual.getType() == BinaryColumn.class && c instanceof BinaryColumn ? OraColumnDefiner.join(c.getQuotedName(), defdef) : OraColumnDefiner.join(definer.getInternalDefinition(c), defdef);
        if (actual.isNullable() != c.isNullable()) {
            def = OraColumnDefiner.join(def, definer.nullable(c));
        }
        if (OraFunctions.fromOrToNClob(c, actual)) {
            String tempName = "\"" + c.getName() + "2\"";
            String sql = String.format("alter table " + tableFullName + " add %s", this.columnDef(c));
            sql = sql.replace(c.getQuotedName(), tempName);
            LOGGER.trace(sql);
            result.add(sql);
            sql = String.format("update " + tableFullName + " set %s = \"%s\"", tempName, c.getName());
            LOGGER.trace(sql);
            result.add(sql);
            sql = String.format("alter table " + tableFullName + " drop column %s", c.getQuotedName());
            LOGGER.trace(sql);
            result.add(sql);
            sql = String.format("alter table " + tableFullName + " rename column %s to %s", tempName, c.getQuotedName());
            LOGGER.trace(sql);
            result.add(sql);
        } else if (actual.getType() == DecimalColumn.class && c instanceof DecimalColumn) {
            result.addAll(this.updateDecimalColumn(conn, (DecimalColumn)c, actual, def));
        } else {
            result.add(this.modifyColumn(tableFullName, def));
        }
        if (c instanceof BooleanColumn && actual.getType() != BooleanColumn.class) {
            String sql = String.format("alter table " + tableFullName + " add constraint %s check (%s in (0, 1))", OraFunctions.getBooleanCheckName(c), c.getQuotedName());
            result.add(sql);
        }
        if (c instanceof IntegerColumn) {
            IntegerColumn ic = (IntegerColumn)c;
            if ("".equals(actual.getDefaultValue())) {
                if (((IntegerColumn)c).getSequence() != null) {
                    String sequenceTriggerName = SchemalessFunctions.generateSequenceTriggerName(ic);
                    String sequenceName = this.sequenceString(c.getParentTable().getGrain().getName(), ic.getSequence().getName());
                    String sql = this.createOrReplaceSequenceTriggerForColumn(sequenceTriggerName, ic, sequenceName);
                    result.add(sql);
                    TriggerQuery q = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName()).withName(sequenceTriggerName);
                    this.rememberTrigger(q);
                }
            } else {
                Pattern p = Pattern.compile("(?i)NEXTVAL\\((.*)\\)");
                Matcher m = p.matcher(actual.getDefaultValue());
                if (m.matches()) {
                    if (ic.getSequence() == null) {
                        TriggerQuery triggerQuery = new TriggerQuery().withSchema(c.getParentTable().getGrain().getName()).withTableName(c.getParentTable().getName()).withName(SchemalessFunctions.generateSequenceTriggerName(ic)).withType(TriggerType.PRE_INSERT);
                        triggerExists = this.triggerExists(conn, query);
                        if (triggerExists) {
                            result.add(this.dropTrigger(triggerQuery));
                        }
                    } else {
                        String oldSequenceName = m.group(1);
                        if (!oldSequenceName.equals(ic.getSequence().getName())) {
                            String sequenceName = this.sequenceString(c.getParentTable().getGrain().getName(), ic.getSequence().getName());
                            String sql = this.createOrReplaceSequenceTriggerForColumn(SchemalessFunctions.generateSequenceTriggerName(ic), ic, sequenceName);
                            result.add(sql);
                            TriggerQuery triggerQuery = new TriggerQuery().withSchema(c.getParentTable().getGrain().getName()).withTableName(c.getParentTable().getName()).withName(SchemalessFunctions.generateSequenceTriggerName(ic)).withType(TriggerType.PRE_INSERT);
                            this.rememberTrigger(triggerQuery);
                        }
                    }
                } else if (ic.getSequence() != null) {
                    String sequenceName = this.sequenceString(c.getParentTable().getGrain().getName(), ic.getSequence().getName());
                    String sql = this.createOrReplaceSequenceTriggerForColumn(SchemalessFunctions.generateSequenceTriggerName(ic), ic, sequenceName);
                    result.add(sql);
                }
            }
        }
        return result;
    }

    @Override
    List<String> createIndex(Index index) {
        String grainName = index.getTable().getGrain().getName();
        String fieldList = CommonFunctions.getFieldList(index.getColumns().keySet());
        String sql = String.format("CREATE INDEX " + this.tableString(grainName, index.getName()) + " ON " + this.tableString(grainName, index.getTable().getName()) + " (%s)", fieldList);
        return Arrays.asList(sql);
    }

    private String createOrReplaceSequenceTriggerForColumn(String triggerName, IntegerColumn ic, String quotedSequenceName) {
        TableElement t = ic.getParentTable();
        String sql = String.format("CREATE OR REPLACE TRIGGER \"" + triggerName + "\" BEFORE INSERT ON " + this.tableString(t.getGrain().getName(), t.getName()) + " FOR EACH ROW WHEN (new.%s is null) BEGIN SELECT " + quotedSequenceName + ".NEXTVAL INTO :new.%s FROM dual; END;", ic.getQuotedName(), ic.getQuotedName());
        return sql;
    }

    @Override
    void processCreateUpdateRule(Connection conn, ForeignKey fk, LinkedList<StringBuilder> sqlQueue) {
        String triggerName;
        StringBuilder sb;
        String snlTriggerName = OraDdlGenerator.getFKTriggerName("snl_", fk.getConstraintName());
        String cscTriggerName = OraDdlGenerator.getFKTriggerName("csc_", fk.getConstraintName());
        TriggerQuery query = new TriggerQuery().withSchema(fk.getParentTable().getGrain().getName()).withTableName(fk.getParentTable().getName()).withName(snlTriggerName).withType(TriggerType.POST_UPDATE);
        boolean snlTriggerExists = this.triggerExists(conn, query);
        query.withName(cscTriggerName);
        boolean cscTriggerExists = this.triggerExists(conn, query);
        if (snlTriggerExists || cscTriggerExists) {
            sb = new StringBuilder("drop trigger ").append("\"");
            switch (fk.getUpdateRule()) {
                case CASCADE: {
                    if (!snlTriggerExists) break;
                    sb.append(OraDdlGenerator.getFKTriggerName("snl_", fk.getConstraintName()));
                    sb.append("\"");
                    sqlQueue.add(sb);
                    this.forgetTrigger(query.withName(snlTriggerName));
                    break;
                }
                case SET_NULL: {
                    if (!cscTriggerExists) break;
                    sb.append(OraDdlGenerator.getFKTriggerName("csc_", fk.getConstraintName()));
                    sb.append("\"");
                    sqlQueue.add(sb);
                    this.forgetTrigger(query.withName(cscTriggerName));
                    break;
                }
                default: {
                    if (snlTriggerExists && cscTriggerExists) {
                        sb.append(OraDdlGenerator.getFKTriggerName("snl_", fk.getConstraintName()));
                        sb.append("\"");
                        sqlQueue.add(sb);
                        this.forgetTrigger(query.withName(snlTriggerName));
                        sb = new StringBuilder("drop trigger ");
                        sb.append(OraDdlGenerator.getFKTriggerName("csc_", fk.getConstraintName()));
                        sb.append("\"");
                        sqlQueue.add(sb);
                        this.forgetTrigger(query.withName(snlTriggerName));
                    }
                    return;
                }
            }
        }
        sb = new StringBuilder();
        sb.append("create or replace trigger \"");
        if (fk.getUpdateRule() == FKRule.CASCADE) {
            triggerName = OraDdlGenerator.getFKTriggerName("csc_", fk.getConstraintName());
            sb.append(triggerName);
            query.withName(triggerName);
        } else {
            triggerName = OraDdlGenerator.getFKTriggerName("snl_", fk.getConstraintName());
            sb.append(triggerName);
            query.withName(triggerName);
        }
        sb.append("\" after update of ");
        BasicTable t = fk.getReferencedTable();
        boolean needComma = false;
        for (Column<?> c : t.getPrimaryKey().values()) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(c.getQuotedName());
            needComma = true;
        }
        sb.append(String.format(" on \"%s_%s\"", t.getGrain().getName(), t.getName()));
        sb.append(String.format(" for each row begin\n  update \"%s_%s\" set ", fk.getParentTable().getGrain().getName(), fk.getParentTable().getName()));
        Iterator<Column<?>> i1 = fk.getColumns().values().iterator();
        Iterator<Column<?>> i2 = t.getPrimaryKey().values().iterator();
        needComma = false;
        while (i1.hasNext()) {
            sb.append(needComma ? ",\n    " : "\n    ");
            needComma = true;
            sb.append(i1.next().getQuotedName());
            sb.append(" = :new.");
            sb.append(i2.next().getQuotedName());
        }
        sb.append("\n  where ");
        i1 = fk.getColumns().values().iterator();
        i2 = t.getPrimaryKey().values().iterator();
        needComma = false;
        while (i1.hasNext()) {
            sb.append(needComma ? ",\n    " : "\n    ");
            needComma = true;
            sb.append(i1.next().getQuotedName());
            if (fk.getUpdateRule() == FKRule.CASCADE) {
                sb.append(" = :old.");
                sb.append(i2.next().getQuotedName());
                continue;
            }
            sb.append(" = null");
        }
        sb.append(";\nend;");
        sqlQueue.add(sb);
        this.rememberTrigger(query);
    }

    @Override
    public SQLGenerator getViewSQLGenerator() {
        return new SQLGenerator(){

            @Override
            protected String viewName(AbstractView v) {
                return OraDdlGenerator.this.tableString(v.getGrain().getName(), v.getName());
            }

            @Override
            protected String tableName(TableRef tRef) {
                BasicTable t = tRef.getTable();
                return String.format(OraDdlGenerator.this.tableString(t.getGrain().getName(), t.getName()) + " \"%s\"", tRef.getAlias());
            }

            @Override
            protected String checkForDate(String lexValue) {
                try {
                    return OraFunctions.translateDate(lexValue);
                }
                catch (CelestaException e) {
                    return lexValue;
                }
            }

            @Override
            protected String boolLiteral(boolean val) {
                return val ? "1" : "0";
            }

            @Override
            protected String paramLiteral(String paramName) {
                return paramName;
            }

            @Override
            protected String getDate() {
                return "CURRENT_TIMESTAMP";
            }
        };
    }

    @Override
    List<String> createParameterizedView(ParameterizedView pv) {
        ArrayList<String> result = new ArrayList<String>();
        String colsDef = pv.getColumns().entrySet().stream().map(e -> {
            StringBuilder sb = new StringBuilder("\"").append((String)e.getKey()).append("\" ").append(ColumnDefinerFactory.getColumnDefiner(this.getType(), (Class)CELESTA_TYPES_COLUMN_CLASSES.get(((ViewColumnMeta)e.getValue()).getCelestaType())).dbFieldType());
            Column<?> colRef = pv.getColumnRef((String)e.getKey());
            if (colRef != null && "VARCHAR".equals(colRef.getCelestaType())) {
                StringColumn sc = (StringColumn)colRef;
                sb.append("(").append(sc.getLength()).append(")");
            }
            return sb.toString();
        }).collect(Collectors.joining(",\n"));
        String sql = String.format("create type " + this.tableString(pv.getGrain().getName(), pv.getName() + "_o") + " as object\n(%s)", colsDef);
        LOGGER.trace(sql);
        result.add(sql);
        sql = "create type " + this.tableString(pv.getGrain().getName(), pv.getName() + "_t") + " as TABLE OF " + this.tableString(pv.getGrain().getName(), pv.getName() + "_o");
        LOGGER.trace(sql);
        result.add(sql);
        SQLGenerator gen = this.getViewSQLGenerator();
        StringWriter sw = new StringWriter();
        PrintWriter bw = new PrintWriter(sw);
        try {
            pv.selectScript(bw, gen);
        }
        catch (IOException e2) {
            throw new CelestaException(e2);
        }
        bw.flush();
        String pvParams = pv.getParameters().entrySet().stream().map(e -> (String)e.getKey() + " IN " + ColumnDefinerFactory.getColumnDefiner(this.getType(), (Class)CELESTA_TYPES_COLUMN_CLASSES.get(((Parameter)e.getValue()).getType().getCelestaType())).dbFieldType()).collect(Collectors.joining(", "));
        String selectSql = sw.toString();
        String objectParams = pv.getColumns().keySet().stream().map(alias -> "curr.\"" + alias + "\"").collect(Collectors.joining(", "));
        sql = String.format("create or replace function " + this.tableString(pv.getGrain().getName(), pv.getName()) + "(%s) return " + this.tableString(pv.getGrain().getName(), pv.getName() + "_t") + " PIPELINED IS\nBEGIN\nfor curr in (%s) loop \npipe row (%s(%s));\nend loop;END;", pvParams, selectSql, this.tableString(pv.getGrain().getName(), pv.getName() + "_o"), objectParams);
        result.add(sql);
        return result;
    }

    @Override
    Optional<String> dropAutoIncrement(Connection conn, TableElement t) {
        boolean incSequenceExists;
        String sequenceName = SchemalessFunctions.getIncrementSequenceName(t);
        String sequenceExistsSql = String.format("select count(*) from user_sequences where sequence_name = '%s'", sequenceName);
        try (Statement checkForTable = conn.createStatement();
             ResultSet rs = checkForTable.executeQuery(sequenceExistsSql);){
            incSequenceExists = rs.next() && rs.getInt(1) > 0;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        if (incSequenceExists) {
            String sql = String.format("DROP SEQUENCE \"%s\"", sequenceName);
            return Optional.of(sql);
        }
        return Optional.empty();
    }

    @Override
    String truncDate(String dateStr) {
        return "TRUNC(" + dateStr + " , 'DD')";
    }

    @Override
    public List<String> dropTableTriggersForMaterializedViews(Connection conn, BasicTable t) {
        ArrayList<String> result = new ArrayList<String>();
        List mvList = t.getGrain().getElements(MaterializedView.class).values().stream().filter(mv -> mv.getRefTable().getTable().equals(t)).collect(Collectors.toList());
        for (MaterializedView mv2 : mvList) {
            TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName());
            String insertTriggerName = mv2.getTriggerName(TriggerType.POST_INSERT);
            String updateTriggerName = mv2.getTriggerName(TriggerType.POST_UPDATE);
            String deleteTriggerName = mv2.getTriggerName(TriggerType.POST_DELETE);
            query.withName(insertTriggerName);
            if (this.triggerExists(conn, query)) {
                result.add(this.dropTrigger(query));
            }
            query.withName(updateTriggerName);
            if (this.triggerExists(conn, query)) {
                result.add(this.dropTrigger(query));
            }
            query.withName(deleteTriggerName);
            if (!this.triggerExists(conn, query)) continue;
            result.add(this.dropTrigger(query));
        }
        return result;
    }

    @Override
    public List<String> createTableTriggersForMaterializedViews(BasicTable t) {
        ArrayList<String> result = new ArrayList<String>();
        List mvList = t.getGrain().getElements(MaterializedView.class).values().stream().filter(mv -> mv.getRefTable().getTable().equals(t)).collect(Collectors.toList());
        String fullTableName = this.tableString(t.getGrain().getName(), t.getName());
        TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName());
        for (MaterializedView mv2 : mvList) {
            String fullMvName = this.tableString(mv2.getGrain().getName(), mv2.getName());
            String insertTriggerName = mv2.getTriggerName(TriggerType.POST_INSERT);
            String updateTriggerName = mv2.getTriggerName(TriggerType.POST_UPDATE);
            String deleteTriggerName = mv2.getTriggerName(TriggerType.POST_DELETE);
            String lockTable = String.format("LOCK TABLE %s IN EXCLUSIVE MODE;\n", fullMvName);
            String mvColumns = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> "\"" + alias + "\"").collect(Collectors.joining(", "));
            String selectFromRowTemplate = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> {
                Column<?> colRef = mv2.getColumnRef((String)alias);
                if (colRef == null) {
                    Map<String, Expr> aggrCols = mv2.getAggregateColumns();
                    if (aggrCols.containsKey(alias) && aggrCols.get(alias) instanceof Count) {
                        return "1 as \"" + alias + "\"";
                    }
                    return "";
                }
                if ("DATETIME".equals(colRef.getCelestaType())) {
                    return "TRUNC(%1$s.\"" + mv2.getColumnRef((String)alias).getName() + "\", 'DD') as \"" + alias + "\"";
                }
                return "%1$s.\"" + mv2.getColumnRef((String)alias).getName() + "\" as \"" + alias + "\"";
            }).filter(str -> !str.isEmpty()).collect(Collectors.joining(", "));
            String rowColumnsTemplate = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> "%1$s.\"" + alias + "\"").collect(Collectors.joining(", "));
            String rowConditionTemplate = mv2.getColumns().keySet().stream().filter(alias -> mv2.isGroupByColumn((String)alias)).map(alias -> "mv.\"" + alias + "\" = %1$s.\"" + alias + "\"").collect(Collectors.joining(" AND "));
            String rowConditionTemplateForDelete = mv2.getColumns().keySet().stream().filter(alias -> mv2.isGroupByColumn((String)alias)).map(alias -> {
                Column<?> colRef = mv2.getColumnRef((String)alias);
                if ("DATETIME".equals(colRef.getCelestaType())) {
                    return "mv.\"" + alias + "\" = TRUNC(%1$s.\"" + mv2.getColumnRef((String)alias).getName() + "\", 'DD')";
                }
                return "mv.\"" + alias + "\" = %1$s.\"" + mv2.getColumnRef((String)alias).getName() + "\"";
            }).collect(Collectors.joining(" AND "));
            String setStatementTemplate = mv2.getAggregateColumns().entrySet().stream().map(e -> {
                StringBuilder sb = new StringBuilder();
                String alias = (String)e.getKey();
                sb.append("mv.\"").append(alias).append("\" = mv.\"").append(alias).append("\" %1$s ");
                if (e.getValue() instanceof Sum) {
                    sb.append("%2$s.\"").append(alias).append("\"");
                } else if (e.getValue() instanceof Count) {
                    sb.append("1");
                }
                return sb.toString();
            }).collect(Collectors.joining(", ")).concat(", mv.\"").concat("surrogate_count").concat("\" = ").concat("mv.\"").concat("surrogate_count").concat("\" %1$s 1");
            String setStatementTemplateForDelete = mv2.getAggregateColumns().entrySet().stream().map(e -> {
                StringBuilder sb = new StringBuilder();
                String alias = (String)e.getKey();
                sb.append("mv.\"").append(alias).append("\" = mv.\"").append(alias).append("\" %1$s ");
                if (e.getValue() instanceof Sum) {
                    sb.append("%2$s.\"").append(mv2.getColumnRef(alias).getName()).append("\"");
                } else if (e.getValue() instanceof Count) {
                    sb.append("1");
                }
                return sb.toString();
            }).collect(Collectors.joining(", ")).concat(", mv.\"").concat("surrogate_count").concat("\" = ").concat("mv.\"").concat("surrogate_count").concat("\" %1$s 1");
            StringBuilder insertSqlBuilder = new StringBuilder("MERGE INTO %s mv \n").append("USING (SELECT %s FROM dual) \"inserted\" ON (%s) \n").append("WHEN MATCHED THEN \n ").append("UPDATE SET %s \n").append("WHEN NOT MATCHED THEN \n").append("INSERT (%s) VALUES (%s); \n");
            String insertSql = String.format(insertSqlBuilder.toString(), fullMvName, String.format(selectFromRowTemplate, ":new"), String.format(rowConditionTemplate, "\"inserted\""), String.format(setStatementTemplate, "+", "\"inserted\""), mvColumns + ", \"" + "surrogate_count" + "\"", String.format(rowColumnsTemplate, "\"inserted\"") + ", 1");
            String delStatement = String.format("mv.\"%s\" = 0", "surrogate_count");
            StringBuilder deleteSqlBuilder = new StringBuilder(String.format("UPDATE %s mv \n", fullMvName)).append("SET ").append(String.format(setStatementTemplateForDelete, "-", ":old")).append(" ").append("WHERE ").append(String.format(rowConditionTemplateForDelete, ":old")).append(";\n").append(String.format("DELETE FROM %s mv ", fullMvName)).append("WHERE ").append(delStatement).append(";\n");
            String sql = String.format("create or replace trigger \"%s\" after insert on %s for each row\nbegin \n/*CHECKSUM%sCHECKSUM*/\n %s \n %s \n END;", insertTriggerName, fullTableName, mv2.getChecksum(), lockTable, insertSql);
            LOGGER.trace(sql);
            result.add(sql);
            this.rememberTrigger(query.withName(insertTriggerName));
            sql = String.format("create or replace trigger \"%s\" after update on %s for each row\nbegin %s \n %s\n %s\n END;", updateTriggerName, fullTableName, lockTable, deleteSqlBuilder.toString(), insertSql);
            LOGGER.trace(sql);
            result.add(sql);
            this.rememberTrigger(query.withName(updateTriggerName));
            sql = String.format("create or replace trigger \"%s\" after delete on %s for each row\n  begin %s \n %s\n END;", deleteTriggerName, fullTableName, lockTable, deleteSqlBuilder.toString());
            result.add(sql);
            this.rememberTrigger(query.withName(deleteTriggerName));
        }
        return result;
    }

    private List<String> updateDecimalColumn(Connection conn, DecimalColumn dc, DbColumnInfo actual, String def) {
        ArrayList<String> result = new ArrayList<String>();
        String tableFullName = this.tableString(dc.getParentTable().getGrain().getName(), dc.getParentTable().getName());
        int actualScale = actual.getScale();
        int scale = dc.getScale();
        int actualWholePartLength = actual.getLength() - actualScale;
        int wholePartLength = dc.getPrecision() - scale;
        if (scale < actualScale || wholePartLength < actualWholePartLength) {
            boolean hasNullValues;
            if (!actual.isNullable()) {
                result.add(String.format("alter table %s modify (%s null)", tableFullName, dc.getQuotedName()));
            }
            String tempColumnName = String.format("\"%s\"", NamedElement.limitName(String.format("temp%s%s", dc.getName(), UUID.randomUUID().toString())));
            OraColumnDefiner columnDefiner = (OraColumnDefiner)ColumnDefinerFactory.getColumnDefiner(this.getType(), dc.getClass());
            String sql = String.format("alter table  %s add %s %s(%s,%s)", tableFullName, tempColumnName, columnDefiner.dbFieldType(), dc.getPrecision(), dc.getScale());
            result.add(sql);
            sql = String.format("update %s set %s = %s", tableFullName, tempColumnName, dc.getQuotedName());
            result.add(sql);
            sql = String.format("update %s set %s = null", tableFullName, dc.getQuotedName());
            result.add(sql);
            String fillColumnSql = String.format("update %s set %s = %s", tableFullName, dc.getQuotedName(), tempColumnName);
            String selectSql = String.format("select count(*) from %s where %s is null", tableFullName, dc.getQuotedName());
            try (ResultSet rs = SqlUtils.executeQuery(conn, selectSql);){
                rs.next();
                hasNullValues = rs.getInt(1) > 0;
            }
            catch (SQLException e) {
                throw new CelestaException(e);
            }
            if (!dc.isNullable() && !hasNullValues) {
                String defdef = this.defaultDefForAlter(dc, columnDefiner, actual);
                String preDef = OraColumnDefiner.join(columnDefiner.getInternalDefinition(dc), defdef);
                result.add(this.modifyColumn(tableFullName, preDef));
                result.add(fillColumnSql);
                result.add(this.modifyColumn(tableFullName, def));
            } else {
                result.add(this.modifyColumn(tableFullName, def));
                result.add(fillColumnSql);
            }
            sql = String.format("alter table %s drop column %s", tableFullName, tempColumnName);
            result.add(sql);
        } else {
            result.add(this.modifyColumn(tableFullName, def));
        }
        return result;
    }

    private String modifyColumn(String tableFullName, String columnDef) {
        return String.format("alter table " + tableFullName + " modify (%s)", columnDef);
    }

    private String defaultDefForAlter(Column<?> c, ColumnDefiner cd, DbColumnInfo actual) {
        String result = cd.getDefaultDefinition(c);
        if ("".equals(result) && !"".equals(actual.getDefaultValue())) {
            result = "default null";
        }
        return result;
    }
}

