/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import ru.curs.celesta.dbutils.h2.AbstractMaterializeViewTrigger;

public final class MaterializedViewUpdateTrigger
extends AbstractMaterializeViewTrigger {
    private static final String NAME_PREFIX = "mvUpdateFrom";

    public void fire(Connection connection, Object[] oldRow, Object[] newRow) throws SQLException {
        if (this.mvColumnsAreChanged(oldRow, newRow)) {
            this.delete(connection, oldRow);
            this.insert(connection, oldRow);
            this.delete(connection, newRow);
            this.insert(connection, newRow);
        }
    }

    @Override
    String getNamePrefix() {
        return NAME_PREFIX;
    }

    private boolean mvColumnsAreChanged(Object[] oldRow, Object[] newRow) {
        return this.getMvColumnRefs().keySet().stream().anyMatch(i -> !Objects.equals(oldRow[i], newRow[i]));
    }
}

