/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.curs.celesta.CelestaException;

public final class SqlUtils {
    private SqlUtils() {
        throw new AssertionError();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeUpdate(Connection conn, String sql) {
        try (Statement stmt = conn.createStatement();){
            int n = stmt.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw new CelestaException(e);
        }
    }

    public static ResultSet executeQuery(Connection conn, String sql) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            return (ResultSet)Proxy.newProxyInstance(rs.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler(rs));
        }
        catch (SQLException e) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    throw new CelestaException(ex);
                }
            }
            throw new CelestaException(e);
        }
    }

    private static class ResultSetInvocationHandler
    implements InvocationHandler {
        private final ResultSet rs;

        ResultSetInvocationHandler(ResultSet rs) {
            this.rs = rs;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(ResultSet.class.getMethod("close", new Class[0]))) {
                Statement statement = this.rs.getStatement();
                if (!statement.isClosed()) {
                    statement.close();
                }
            } else {
                return method.invoke((Object)this.rs, args);
            }
            return null;
        }
    }
}

