/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.meta;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.ForeignKey;

public final class DbFkInfo {
    private String tableName;
    private String name;
    private String refGrainName;
    private String refTableName;
    private FKRule deleteRule = FKRule.NO_ACTION;
    private FKRule updateRule = FKRule.NO_ACTION;
    private final List<String> columnNames = new LinkedList<String>();

    public DbFkInfo(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRefTableName() {
        return this.refTableName;
    }

    public void setRefTableName(String refTableName) {
        this.refTableName = refTableName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public String getRefGrainName() {
        return this.refGrainName;
    }

    public void setRefGrainName(String refGrainName) {
        this.refGrainName = refGrainName;
    }

    public FKRule getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(FKRule deleteBehaviour) {
        this.deleteRule = deleteBehaviour;
    }

    public FKRule getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(FKRule updateBehaviour) {
        this.updateRule = updateBehaviour;
    }

    public boolean reflects(ForeignKey fk) {
        if (!fk.getParentTable().getName().equals(this.tableName)) {
            return false;
        }
        if (!fk.getReferencedTable().getGrain().getName().equals(this.refGrainName)) {
            return false;
        }
        if (!fk.getReferencedTable().getName().equals(this.refTableName)) {
            return false;
        }
        if (fk.getColumns().size() != this.columnNames.size()) {
            return false;
        }
        Iterator<String> i1 = fk.getColumns().keySet().iterator();
        Iterator<String> i2 = this.columnNames.iterator();
        while (i1.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        if (!fk.getDeleteRule().equals((Object)this.deleteRule)) {
            return false;
        }
        return fk.getUpdateRule().equals((Object)this.updateRule);
    }
}

