/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.term;

import java.util.List;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.dbutils.term.AlwaysFalse;
import ru.curs.celesta.dbutils.term.AlwaysTrue;
import ru.curs.celesta.dbutils.term.WhereTerm;

public final class AndTerm
extends WhereTerm {
    private final WhereTerm l;
    private final WhereTerm r;

    private AndTerm(WhereTerm l, WhereTerm r) {
        this.l = l;
        this.r = r;
    }

    static WhereTerm construct(WhereTerm l, WhereTerm r) {
        if (l instanceof AlwaysFalse || r instanceof AlwaysFalse) {
            return AlwaysFalse.FALSE;
        }
        if (l instanceof AlwaysTrue) {
            return r;
        }
        if (r instanceof AlwaysTrue) {
            return l;
        }
        return new AndTerm(l, r);
    }

    @Override
    public String getWhere() {
        String ls = this.l instanceof AndTerm ? ((AndTerm)this.l).getOpenWhere() : this.l.getWhere();
        String rs = this.r instanceof AndTerm ? ((AndTerm)this.r).getOpenWhere() : this.r.getWhere();
        return String.format("(%s and %s)", ls, rs);
    }

    private String getOpenWhere() {
        return String.format("%s and %s", this.l.getWhere(), this.r.getWhere());
    }

    @Override
    public void programParams(List<ParameterSetter> program, QueryBuildingHelper queryBuildingHelper) {
        this.l.programParams(program, queryBuildingHelper);
        this.r.programParams(program, queryBuildingHelper);
    }
}

