/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.curs.celesta.score.AbstractSelectStmt;
import ru.curs.celesta.score.Aggregate;
import ru.curs.celesta.score.BinaryTermOp;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.FieldRef;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.Sum;

public abstract class AbstractView
extends DataGrainElement {
    static final Map<Class<? extends Expr>, Function<Expr, Column<?>>> EXPR_CLASSES_AND_COLUMN_EXTRACTORS = new HashMap();
    private final List<AbstractSelectStmt> segments = new ArrayList<AbstractSelectStmt>();

    public final List<AbstractSelectStmt> getSegments() {
        return this.segments;
    }

    public AbstractView(GrainPart grainPart, String name) throws ParseException {
        super(grainPart, name);
    }

    abstract String viewType();

    public void selectScript(PrintWriter bw, SQLGenerator gen) throws IOException {
        BWWrapper bww = new BWWrapper();
        for (int i = 0; i < this.segments.size(); ++i) {
            AbstractSelectStmt viewSegment = this.segments.get(i);
            if (i > 0) {
                bw.println(" union all ");
            }
            viewSegment.writeSelectPart(bw, gen, bww);
            viewSegment.writeFromPart(bw, gen);
            viewSegment.writeWherePart(bw, gen);
            viewSegment.writeGroupByPart(bw, gen);
        }
    }

    abstract AbstractSelectStmt newSelectStatement();

    final AbstractSelectStmt addSelectStatement() {
        AbstractSelectStmt result = this.newSelectStatement();
        this.segments.add(result);
        return result;
    }

    void finalizeParsing() throws ParseException {
        if (this.segments.size() == 0) {
            throw new IllegalStateException();
        }
        Expr[] first = this.segments.get((int)0).columns.values().toArray(new Expr[0]);
        for (int i = 1; i < this.segments.size(); ++i) {
            Expr[] current = this.segments.get((int)i).columns.values().toArray(new Expr[0]);
            if (first.length != current.length) {
                throw new ParseException(String.format("Each UNION query in %s '%s.%s' must have the same number of columns", this.viewType(), this.getGrain().getName(), this.getName()));
            }
            for (int j = 0; j < first.length; ++j) {
                try {
                    current[j].assertType(first[j].getMeta().getColumnType());
                    first[j].getMeta().setNullable(first[j].getMeta().isNullable() | current[j].getMeta().isNullable());
                    continue;
                }
                catch (ParseException e) {
                    throw new ParseException(String.format("UNION types in %s '%s.%s' must match. %s", this.viewType(), this.getGrain().getName(), this.getName(), e.getMessage()));
                }
            }
        }
    }

    @Override
    public abstract Map<String, ? extends ColumnMeta<?>> getColumns();

    @Override
    public int getColumnIndex(String name) {
        int i = -1;
        for (String c : this.getColumns().keySet()) {
            ++i;
            if (!c.equals(name)) continue;
            return i;
        }
        return i;
    }

    public final Map<String, Expr> getAggregateColumns() {
        if (this.segments.size() > 0) {
            return this.segments.get((int)0).columns.entrySet().stream().filter(e -> e.getValue() instanceof Aggregate).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, o2) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", o));
            }, LinkedHashMap::new));
        }
        return Collections.emptyMap();
    }

    public Column<?> getColumnRef(String colName) {
        if (this.segments.size() > 0) {
            Expr expr = this.segments.get((int)0).columns.get(colName);
            return EXPR_CLASSES_AND_COLUMN_EXTRACTORS.get(expr.getClass()).apply(expr);
        }
        return null;
    }

    static {
        EXPR_CLASSES_AND_COLUMN_EXTRACTORS.put(Count.class, frExpr -> null);
        EXPR_CLASSES_AND_COLUMN_EXTRACTORS.put(FieldRef.class, frExpr -> {
            FieldRef fr = (FieldRef)frExpr;
            return fr.getColumn();
        });
        EXPR_CLASSES_AND_COLUMN_EXTRACTORS.put(Sum.class, sumExpr -> {
            Sum sum = (Sum)sumExpr;
            if (sum.term instanceof BinaryTermOp) {
                return null;
            }
            FieldRef fr = (FieldRef)sum.term;
            return fr.getColumn();
        });
    }

    static class BWWrapper {
        private static final int LINE_SIZE = 80;
        private static final String PADDING = "    ";
        private int l = 0;

        BWWrapper() {
        }

        void append(String s, PrintWriter bw) throws IOException {
            bw.write(s);
            this.l += s.length();
            if (this.l >= 80) {
                bw.println();
                bw.write(PADDING);
                this.l = PADDING.length();
            }
        }
    }
}

