/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.List;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.LogicValuedExpr;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.ViewColumnType;

public final class BinaryLogicalOp
extends LogicValuedExpr {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final String[] OPS = new String[]{" AND ", " OR "};
    private final int operator;
    private final List<Expr> operands;

    BinaryLogicalOp(int operator, List<Expr> operands) throws ParseException {
        if (operator < 0 || operator >= OPS.length) {
            throw new IllegalArgumentException();
        }
        if (operands.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (Expr e : operands) {
            if (e.getMeta().getColumnType() == ViewColumnType.LOGIC) continue;
            throw new ParseException(String.format("Expression '%s' is expected to be logical condition.", e.getCSQL()));
        }
        this.operands = operands;
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public List<Expr> getOperands() {
        return this.operands;
    }

    @Override
    public List<Expr> getAllOperands() {
        return this.getOperands();
    }

    @Override
    public void accept(ExprVisitor visitor) throws ParseException {
        for (Expr e : this.operands) {
            e.accept(visitor);
        }
        visitor.visitBinaryLogicalOp(this);
    }
}

