/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.List;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.ViewColumnMeta;
import ru.curs.celesta.score.ViewColumnType;

public final class BinaryTermOp
extends Expr {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int OVER = 3;
    public static final int CONCAT = 4;
    public static final String[] OPS = new String[]{" + ", " - ", " * ", " / ", " || "};
    private ViewColumnMeta<?> meta;
    private final int operator;
    private final List<Expr> operands;

    BinaryTermOp(int operator, List<Expr> operands) {
        if (operator < 0 || operator >= OPS.length) {
            throw new IllegalArgumentException();
        }
        if (operands.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.operands = operands;
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public List<Expr> getOperands() {
        return this.operands;
    }

    @Override
    public ViewColumnMeta<?> getMeta() {
        if (this.meta == null) {
            block0 : switch (this.operator) {
                case 4: {
                    this.meta = new ViewColumnMeta(ViewColumnType.TEXT);
                    break;
                }
                case 3: {
                    this.meta = new ViewColumnMeta(ViewColumnType.REAL);
                    break;
                }
                default: {
                    for (Expr o : this.operands) {
                        if (o.getMeta().getColumnType() == ViewColumnType.REAL) {
                            this.meta = new ViewColumnMeta(ViewColumnType.REAL);
                            break block0;
                        }
                        if (o.getMeta().getColumnType() != ViewColumnType.DECIMAL) continue;
                        this.meta = new ViewColumnMeta(ViewColumnType.DECIMAL);
                        break block0;
                    }
                    this.meta = new ViewColumnMeta(ViewColumnType.INT);
                }
            }
            boolean n = false;
            for (Expr o : this.operands) {
                if (!o.getMeta().isNullable()) continue;
                n = true;
                break;
            }
            this.meta.setNullable(n);
        }
        return this.meta;
    }

    @Override
    public void accept(ExprVisitor visitor) throws ParseException {
        for (Expr e : this.operands) {
            e.accept(visitor);
        }
        visitor.visitBinaryTermOp(this);
    }
}

