/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableElement;

public final class BooleanColumn
extends Column<Boolean> {
    public static final String CELESTA_TYPE = "BIT";
    private Boolean defaultvalue;

    public BooleanColumn(TableElement table, String name) throws ParseException {
        super(table, name);
    }

    @Override
    protected void setDefault(String lexvalue) throws ParseException {
        this.defaultvalue = BooleanColumn.parseSQLBool(lexvalue);
    }

    public static Boolean parseSQLBool(String lexvalue) throws ParseException {
        if (lexvalue == null) {
            return null;
        }
        if ("'TRUE'".equalsIgnoreCase(lexvalue) || "TRUE".equalsIgnoreCase(lexvalue) || "1".equals(lexvalue)) {
            return true;
        }
        if ("'FALSE'".equalsIgnoreCase(lexvalue) || "FALSE".equalsIgnoreCase(lexvalue) || "0".equals(lexvalue)) {
            return false;
        }
        throw new ParseException("Default boolean value should be either 'TRUE'/1 or 'FALSE'/0.");
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultvalue;
    }

    @Override
    public String jdbcGetterName() {
        return "getBoolean";
    }

    @Override
    public String getCelestaType() {
        return CELESTA_TYPE;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.class;
    }

    @Override
    public String getCelestaDefault() {
        return this.defaultvalue == null ? null : "'" + this.defaultvalue.toString().toUpperCase() + "'";
    }
}

