/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

final class ChecksumInputStream
extends InputStream {
    private final CRC32 checksum;
    private final InputStream input;
    private int counter = 0;

    ChecksumInputStream(InputStream input) {
        this.input = input;
        this.checksum = new CRC32();
    }

    ChecksumInputStream(InputStream input, ChecksumInputStream cis) {
        this.input = input;
        this.checksum = cis.checksum;
    }

    @Override
    public int read() throws IOException {
        int result = this.input.read();
        if (result >= 0) {
            ++this.counter;
            this.checksum.update(result);
        }
        return result;
    }

    public int getCRC32() {
        return (int)this.checksum.getValue();
    }

    public int getCount() {
        return this.counter;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

