/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.List;
import org.json.JSONException;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.score.CelestaDocUtils;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableElement;

public abstract class Column<V>
extends NamedElement
implements ColumnMeta<V> {
    private final TableElement parentTable;
    private boolean nullable = true;

    Column(TableElement parentTable, String name) throws ParseException {
        super(name, parentTable.getGrain().getScore().getIdentifierParser());
        if ("recversion".equals(name)) {
            throw new ParseException(String.format("Column name '%s' is reserved for system needs.", "recversion"));
        }
        this.parentTable = parentTable;
        parentTable.addColumn(this);
    }

    Column(TableElement parentTable) throws ParseException {
        super("recversion", parentTable.getGrain().getScore().getIdentifierParser());
        this.parentTable = parentTable;
        this.nullable = false;
        this.setDefault("1");
    }

    public List<String> getOptions() {
        try {
            return CelestaDocUtils.getList(this.getCelestaDoc(), "option");
        }
        catch (JSONException e1) {
            throw new CelestaException("Error in CelestaDoc for %s.%s.%s: %s", this.getParentTable().getGrain().getName(), this.getParentTable().getName(), this.getName(), e1.getMessage());
        }
    }

    protected abstract void setDefault(String var1) throws ParseException;

    public String toString() {
        return this.getName();
    }

    public final TableElement getParentTable() {
        return this.parentTable;
    }

    public final void setNullableAndDefault(boolean nullable, String defaultValue) throws ParseException {
        this.parentTable.getGrain().modify();
        String buf = defaultValue;
        this.nullable = nullable;
        this.setDefault(buf);
    }

    @Override
    public final boolean isNullable() {
        return this.nullable;
    }

    public final void delete() throws ParseException {
        this.parentTable.removeColumn(this);
    }

    public abstract V getDefaultValue();

    public abstract String getCelestaDefault();
}

