/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.math.BigDecimal;
import java.math.BigInteger;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableElement;

public final class DecimalColumn
extends Column<BigDecimal> {
    public static final int MAX_PRECISION = 38;
    public static final String CELESTA_TYPE = "DECIMAL";
    private int precision;
    private int scale;
    private BigDecimal defaultValue;

    public DecimalColumn(TableElement table, String name, int precision, int scale) throws ParseException {
        super(table, name);
        if (precision < 1 || precision > 38) {
            throw new ParseException(String.format("Illegal precision %s (must be between 1 and %s inclusive) for column %s.%s.%s", precision, 38, this.getParentTable().getGrain().getName(), this.getParentTable().getName(), this.getName()));
        }
        if (scale < 0 || scale > precision) {
            throw new ParseException(String.format("Illegal scale %s (must be between 0 and %s inclusive) for column %s.%s.%s", scale, precision, this.getParentTable().getGrain().getName(), this.getParentTable().getName(), this.getName()));
        }
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    protected void setDefault(String lexValue) throws ParseException {
        BigDecimal value;
        BigDecimal bigDecimal = value = lexValue == null ? null : new BigDecimal(lexValue);
        if (value != null) {
            int wholePartMaxLength = this.precision - this.scale;
            BigInteger wholePart = value.toBigInteger();
            int wholePartLength = wholePart.toString().length();
            if (wholePartLength > wholePartMaxLength) {
                throw new ParseException(String.format("Illegal default value %s for column %s.%s.%s is bigger than specified precision", value.toPlainString(), this.getParentTable().getGrain().getName(), this.getParentTable().getName(), this.getName()));
            }
        }
        this.defaultValue = value == null ? null : value;
    }

    @Override
    public BigDecimal getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getCelestaDefault() {
        return this.defaultValue == null ? null : this.defaultValue.toString();
    }

    @Override
    public String jdbcGetterName() {
        return "getBigDecimal";
    }

    @Override
    public String getCelestaType() {
        return CELESTA_TYPE;
    }

    @Override
    public Class<?> getJavaClass() {
        return BigDecimal.class;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

