/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.List;
import java.util.Map;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.FieldResolver;
import ru.curs.celesta.score.FilterFieldResolver;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.Parameter;
import ru.curs.celesta.score.ParameterResolver;
import ru.curs.celesta.score.ParameterResolverResult;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.TypeChecker;
import ru.curs.celesta.score.ViewColumnMeta;
import ru.curs.celesta.score.ViewColumnType;

public abstract class Expr {
    final void assertType(ViewColumnType t) throws ParseException {
        ViewColumnType columnType = this.getMeta().getColumnType();
        if (t == ViewColumnType.INT || t == ViewColumnType.REAL || t == ViewColumnType.DECIMAL) {
            if (columnType != ViewColumnType.INT && columnType != ViewColumnType.REAL && columnType != ViewColumnType.DECIMAL) {
                throw new ParseException(String.format("Expression '%s' is expected to be of numeric type, but it is %s", this.getCSQL(), this.getMeta().getColumnType().getCelestaType()));
            }
        } else if (columnType != t) {
            throw new ParseException(String.format("Expression '%s' is expected to be of %s type, but it is %s", this.getCSQL(), t.toString(), this.getMeta().getColumnType().getCelestaType()));
        }
    }

    public final String getCSQL() {
        SQLGenerator gen = new SQLGenerator();
        return gen.generateSQL(this);
    }

    public final String getSQL(QueryBuildingHelper dba) {
        SQLGenerator gen = dba.getViewSQLGenerator();
        return gen.generateSQL(this);
    }

    public abstract ViewColumnMeta<?> getMeta();

    final void resolveFieldRefs(List<TableRef> tables) throws ParseException {
        FieldResolver r = new FieldResolver(tables);
        this.accept(r);
    }

    public final void resolveFieldRefs(GrainElement ge) throws ParseException {
        if (ge instanceof DataGrainElement) {
            FilterFieldResolver fr = new FilterFieldResolver((DataGrainElement)ge);
            this.accept(fr);
        }
    }

    final ParameterResolverResult resolveParameterRefs(Map<String, Parameter> parameters) throws ParseException {
        ParameterResolver r = new ParameterResolver(parameters);
        this.accept(r);
        return r.getResult();
    }

    final void validateTypes() throws ParseException {
        TypeChecker c = new TypeChecker();
        this.accept(c);
    }

    abstract void accept(ExprVisitor var1) throws ParseException;
}

