/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.ViewColumnMeta;
import ru.curs.celesta.score.ViewColumnType;
import ru.curs.celesta.score.ZonedDateTimeColumn;

public final class FieldRef
extends Expr {
    private String tableNameOrAlias;
    private String columnName;
    private Column<?> column = null;
    private ViewColumnMeta<?> meta;

    public FieldRef(String tableNameOrAlias, String columnName) throws ParseException {
        if (columnName == null) {
            throw new IllegalArgumentException();
        }
        this.tableNameOrAlias = tableNameOrAlias;
        this.columnName = columnName;
    }

    public String getTableNameOrAlias() {
        return this.tableNameOrAlias;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public ViewColumnMeta<?> getMeta() {
        if (this.meta == null) {
            if (this.column != null) {
                if (this.column instanceof IntegerColumn) {
                    this.meta = new ViewColumnMeta(ViewColumnType.INT);
                } else if (this.column instanceof FloatingColumn) {
                    this.meta = new ViewColumnMeta(ViewColumnType.REAL);
                } else if (this.column instanceof DecimalColumn) {
                    this.meta = new ViewColumnMeta(ViewColumnType.DECIMAL);
                } else if (this.column instanceof StringColumn) {
                    StringColumn sc = (StringColumn)this.column;
                    this.meta = sc.isMax() ? new ViewColumnMeta(ViewColumnType.TEXT) : new ViewColumnMeta(ViewColumnType.TEXT, sc.getLength());
                } else if (this.column instanceof BooleanColumn) {
                    this.meta = new ViewColumnMeta(ViewColumnType.BIT);
                } else if (this.column instanceof DateTimeColumn) {
                    this.meta = new ViewColumnMeta(ViewColumnType.DATE);
                } else if (this.column instanceof ZonedDateTimeColumn) {
                    this.meta = new ViewColumnMeta(ViewColumnType.DATE_WITH_TIME_ZONE);
                } else if (this.column instanceof BinaryColumn) {
                    this.meta = new ViewColumnMeta(ViewColumnType.BLOB);
                } else {
                    throw new IllegalStateException();
                }
                this.meta.setNullable(this.column.isNullable());
                this.meta.setCelestaDoc(this.column.getCelestaDoc());
            } else {
                return new ViewColumnMeta(ViewColumnType.UNDEFINED);
            }
        }
        return this.meta;
    }

    public Column<?> getColumn() {
        return this.column;
    }

    void setColumn(Column<?> column) {
        this.column = column;
    }

    void setTableNameOrAlias(String tableNameOrAlias) {
        this.tableNameOrAlias = tableNameOrAlias;
    }

    void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void accept(ExprVisitor visitor) throws ParseException {
        visitor.visitFieldRef(this);
    }
}

