/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.FieldRef;
import ru.curs.celesta.score.ParseException;

final class FilterFieldResolver
extends ExprVisitor {
    private final DataGrainElement ge;

    public FilterFieldResolver(DataGrainElement ge) {
        this.ge = ge;
    }

    @Override
    void visitFieldRef(FieldRef expr) throws ParseException {
        if (expr.getTableNameOrAlias() != null) {
            throw new ParseException(String.format("Invalid column reference %s.%s: no table references allowed in complex filters.", expr.getTableNameOrAlias(), expr.getColumnName()));
        }
        if (!this.ge.getColumns().containsKey(expr.getColumnName())) {
            throw new ParseException(String.format("Invalid complex filter: table or view \"%s\" does not contain column \"%s\"", this.ge.getName(), expr.getColumnName()));
        }
    }
}

