/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableElement;

public final class FloatingColumn
extends Column<Double> {
    public static final String CELESTA_TYPE = "REAL";
    private Double defaultValue;

    public FloatingColumn(TableElement table, String name) throws ParseException {
        super(table, name);
    }

    @Override
    protected void setDefault(String lexvalue) {
        this.defaultValue = lexvalue == null ? null : Double.valueOf(Double.parseDouble(lexvalue));
    }

    @Override
    public Double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String jdbcGetterName() {
        return "getDouble";
    }

    @Override
    public String getCelestaType() {
        return CELESTA_TYPE;
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.class;
    }

    @Override
    public String getCelestaDefault() {
        return this.defaultValue == null ? null : this.defaultValue.toString();
    }
}

