/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.HasColumns;
import ru.curs.celesta.score.NamedElementHolder;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.StringColumn;

public class Index
extends GrainElement
implements HasColumns {
    private static final Logger LOGGER = LoggerFactory.getLogger(Index.class);
    private static final String INDEX_CREATION_ERROR = "Error while creating index '%s': column '%s' in table '%s' is ";
    private final BasicTable table;
    private final NamedElementHolder<Column<?>> columns = new NamedElementHolder<Column<?>>(){

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Column '%s' is defined more than once in index '%s'", name, Index.this.getName());
        }
    };

    Index(GrainPart grainPart, String tableName, String name) throws ParseException {
        super(grainPart, name);
        if (tableName == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.table = this.getGrain().getElement(tableName, BasicTable.class);
        this.getGrain().addIndex(this);
        this.table.addIndex(this);
    }

    public Index(BasicTable t, String name, String[] columns) throws ParseException {
        this(t.getGrainPart(), t.getName(), name);
        for (String n : columns) {
            this.addColumn(n);
        }
        this.finalizeIndex();
    }

    public BasicTable getTable() {
        return this.table;
    }

    void addColumn(String columnName) throws ParseException {
        if (columnName == null) {
            throw new IllegalArgumentException();
        }
        Column<?> c = this.table.getColumns().get(columnName);
        if (c == null) {
            throw new ParseException(String.format("Error while creating index '%s': column '%s' in table '%s' is not defined.", this.getName(), columnName, this.table.getName()));
        }
        if (c instanceof BinaryColumn) {
            throw new ParseException(String.format("Error while creating index '%s': column '%s' in table '%s' is of long binary type and therefore cannot be a part of an index.", this.getName(), columnName, this.table.getName()));
        }
        if (c instanceof StringColumn && ((StringColumn)c).isMax()) {
            throw new ParseException(String.format("Error while creating index '%s': column '%s' in table '%s' is of TEXT type and therefore cannot be a part of an index.", this.getName(), columnName, this.table.getName()));
        }
        if (c.isNullable()) {
            LOGGER.warn("WARNING for index '{}': column '{}' in table '{}' is nullable and this can affect performance.", new Object[]{this.getName(), columnName, this.table.getName()});
        }
        this.columns.addElement(c);
    }

    void finalizeIndex() throws ParseException {
        if (Arrays.equals(this.getColumns().entrySet().toArray(), this.table.getPrimaryKey().entrySet().toArray())) {
            throw new ParseException(String.format("Can't add index %s to table %s.%s. Primary key with same columns and order already exists.", this.getName(), this.table.getGrain().getName(), this.table.getName()));
        }
        for (Index ind : this.getGrain().getIndices().values()) {
            if (ind == this || ind.table != this.table || ind.columns.size() != this.columns.size()) continue;
            Iterator<Column<?>> i = ind.columns.iterator();
            boolean coincide = true;
            for (Column<?> c : this.columns) {
                if (c == i.next()) continue;
                coincide = false;
                break;
            }
            if (!coincide) continue;
            throw new ParseException(String.format("Error while creating index '%s': it is duplicate of index '%s' for table '%s'", this.getName(), ind.getName(), this.table.getName()));
        }
    }

    public Map<String, Column<?>> getColumns() {
        return this.columns.getElements();
    }

    public void delete() throws ParseException {
        this.getGrain().removeIndex(this);
    }

    @Override
    public int getColumnIndex(String name) {
        return this.columns.getIndex(name);
    }
}

