/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.AbstractSelectStmt;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.CelestaSerializer;
import ru.curs.celesta.score.ChecksumInputStream;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedSelectStmt;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.NamedElementHolder;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.ZonedDateTimeColumn;

public final class MaterializedView
extends AbstractView
implements TableElement {
    public static final String SURROGATE_COUNT = "surrogate_count";
    private static final String CHECKSUM_SEPARATOR = "CHECKSUM";
    public static final String CHECKSUM_COMMENT_TEMPLATE = "/*CHECKSUM%sCHECKSUM*/";
    private final IntegerColumn surrogateCount;
    static final Map<Class<? extends Column<?>>, MatColFabricFunction> COL_CLASSES_AND_FABRIC_FUNCS = new HashMap();
    private final NamedElementHolder<Column<?>> realColumns = new NamedElementHolder<Column<?>>(){

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Column '%s' defined more than once in table '%s'.", name, MaterializedView.this.getName());
        }
    };
    final NamedElementHolder<Column<?>> pk = new NamedElementHolder<Column<?>>(){

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Column '%s' defined more than once for primary key in table '%s'.", name, MaterializedView.this.getName());
        }
    };

    public IntegerColumn getSurrogateCount() {
        return this.surrogateCount;
    }

    public MaterializedView(GrainPart grainPart, String name) throws ParseException {
        super(grainPart, name);
        this.getGrain().addElement(this);
        this.surrogateCount = new IntegerColumn(this, SURROGATE_COUNT);
        this.surrogateCount.setNullableAndDefault(false, "0");
    }

    @Override
    String viewType() {
        return "materialized view";
    }

    @Override
    AbstractSelectStmt newSelectStatement() {
        return new MaterializedSelectStmt(this);
    }

    @Override
    public Map<String, Column<?>> getColumns() {
        return this.realColumns.getElements();
    }

    public List<String> getColumnRefNames() {
        if (this.getSegments().size() > 0) {
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<String, Expr> entry : this.getSegments().get((int)0).columns.entrySet()) {
                Expr expr = entry.getValue();
                if (expr instanceof Count) continue;
                Column colRef = (Column)((Function)EXPR_CLASSES_AND_COLUMN_EXTRACTORS.get(expr.getClass())).apply(expr);
                result.add(colRef.getName());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public Column<?> getColumn(String colName) throws ParseException {
        Column<?> result = this.realColumns.get(colName);
        if (result == null) {
            throw new ParseException(String.format("Column '%s' not found in materialized view '%s.%s'", colName, this.getGrain().getName(), this.getName()));
        }
        return result;
    }

    @Override
    public void addColumn(Column<?> column) throws ParseException {
        if (column.getParentTable() != this) {
            throw new IllegalArgumentException();
        }
        this.getGrain().modify();
        this.realColumns.addElement(column);
    }

    @Override
    public synchronized void removeColumn(Column<?> column) throws ParseException {
        if (this.pk.contains(column)) {
            throw new ParseException(String.format("Table '%s.%s', field '%s': you cannot drop a column that belongs to a primary key. Change primary key first.", this.getGrain().getName(), this.getName(), column.getName()));
        }
        for (Index ind : this.getGrain().getIndices().values()) {
            if (!ind.getColumns().containsValue(column)) continue;
            throw new ParseException(String.format("Table '%s.%s', field '%s': you cannot drop a column that belongs to an index. Drop or change relevant index first.", this.getGrain().getName(), this.getName(), column.getName()));
        }
        this.getGrain().modify();
        this.realColumns.remove(column);
    }

    @Override
    public boolean hasPrimeKey() {
        return !this.pk.getElements().isEmpty();
    }

    @Override
    public String getPkConstraintName() {
        return MaterializedView.limitName("pk_" + this.getName());
    }

    @Override
    public Map<String, Column<?>> getPrimaryKey() {
        return this.pk.getElements();
    }

    public TableRef getRefTable() {
        return this.getSegments().get((int)0).tables.values().stream().findFirst().get();
    }

    public boolean isGroupByColumn(String alias) {
        return this.getSegments().get((int)0).groupByColumns.containsKey(alias);
    }

    public String getSelectPartOfScript() {
        try {
            SQLGenerator gen = new SQLGenerator();
            StringWriter sw = new StringWriter();
            PrintWriter bw = new PrintWriter(sw);
            AbstractView.BWWrapper bww = new AbstractView.BWWrapper();
            this.getSegments().get(0).writeSelectPart(bw, gen, bww);
            bw.flush();
            return sw.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getGroupByPartOfScript() {
        try {
            SQLGenerator gen = new SQLGenerator();
            StringWriter sw = new StringWriter();
            PrintWriter bw = new PrintWriter(sw);
            this.getSegments().get(0).writeGroupByPart(bw, gen);
            bw.flush();
            return sw.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getChecksum() {
        try (ChecksumInputStream is = new ChecksumInputStream(new ByteArrayInputStream(CelestaSerializer.toString(this).getBytes(StandardCharsets.UTF_8)));){
            while (is.read() != -1) {
            }
            String string = String.format("%08X", is.getCRC32());
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getTriggerName(TriggerType type) {
        BasicTable t = this.getRefTable().getTable();
        TriggerNameBuilder tnb = new TriggerNameBuilder().withSchema(this.getGrain().getName()).withTableName(t.getName()).withName(this.getName()).withType(type);
        return tnb.build();
    }

    static {
        COL_CLASSES_AND_FABRIC_FUNCS.put(IntegerColumn.class, (mView, colRef, alias) -> new IntegerColumn(mView, alias));
        COL_CLASSES_AND_FABRIC_FUNCS.put(FloatingColumn.class, (mView, colRef, alias) -> new FloatingColumn(mView, alias));
        COL_CLASSES_AND_FABRIC_FUNCS.put(DecimalColumn.class, (mView, colRef, alias) -> {
            DecimalColumn dc = (DecimalColumn)colRef;
            int precision = dc.getPrecision();
            int scale = dc.getScale();
            return new DecimalColumn(mView, alias, precision, scale);
        });
        COL_CLASSES_AND_FABRIC_FUNCS.put(BooleanColumn.class, (mView, colRef, alias) -> new BooleanColumn(mView, alias));
        COL_CLASSES_AND_FABRIC_FUNCS.put(BinaryColumn.class, (mView, colRef, alias) -> new BinaryColumn(mView, alias));
        COL_CLASSES_AND_FABRIC_FUNCS.put(DateTimeColumn.class, (mView, colRef, alias) -> new DateTimeColumn(mView, alias));
        COL_CLASSES_AND_FABRIC_FUNCS.put(ZonedDateTimeColumn.class, (mView, colRef, alias) -> new ZonedDateTimeColumn(mView, alias));
        COL_CLASSES_AND_FABRIC_FUNCS.put(StringColumn.class, (mView, colRef, alias) -> {
            StringColumn result = new StringColumn(mView, alias);
            StringColumn strColRef = (StringColumn)colRef;
            result.setLength(String.valueOf(strColRef.getLength()));
            return result;
        });
    }

    static final class TriggerNameBuilder {
        private static final Map<TriggerType, String> TRIGGER_TYPES_TO_NAME_PARTS = new HashMap<TriggerType, String>();
        private static final String TEMPLATE = "mv%sFrom%s_%sTo%s_%s";
        private String schema;
        private String tableName;
        private String name;
        private TriggerType type;

        TriggerNameBuilder() {
        }

        public TriggerNameBuilder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public TriggerNameBuilder withSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public TriggerNameBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public TriggerNameBuilder withType(TriggerType type) {
            this.type = type;
            return this;
        }

        public String build() {
            String preResult = String.format(TEMPLATE, TRIGGER_TYPES_TO_NAME_PARTS.get((Object)this.type), this.schema, this.tableName, this.schema, this.name);
            return NamedElement.limitName(preResult);
        }

        static {
            TRIGGER_TYPES_TO_NAME_PARTS.put(TriggerType.POST_INSERT, "Insert");
            TRIGGER_TYPES_TO_NAME_PARTS.put(TriggerType.POST_UPDATE, "Update");
            TRIGGER_TYPES_TO_NAME_PARTS.put(TriggerType.POST_DELETE, "Delete");
        }
    }

    @FunctionalInterface
    static interface MatColFabricFunction {
        public Column<?> apply(MaterializedView var1, Column<?> var2, String var3) throws ParseException;
    }
}

