/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ParameterResolverResult;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.ViewSelectStmt;

public final class ParameterizedViewSelectStmt
extends ViewSelectStmt {
    final ParameterizedView view;
    private Set<String> unusedParameters;

    public ParameterizedViewSelectStmt(ParameterizedView view) {
        super(view);
        this.view = view;
    }

    @Override
    void finalizeWhereConditionParsing() throws ParseException {
        ArrayList<TableRef> t = new ArrayList<TableRef>(this.tables.values());
        if (this.whereCondition != null) {
            this.whereCondition.resolveFieldRefs(t);
            ParameterResolverResult paramResolveResult = this.whereCondition.resolveParameterRefs(this.view.parameters);
            this.unusedParameters = paramResolveResult.getUnusedParameters();
            this.whereCondition.validateTypes();
            this.view.parameterRefsWithOrder.addAll(paramResolveResult.getParametersWithUsageOrder());
        } else {
            this.unusedParameters = new LinkedHashSet<String>(this.view.parameters.keySet());
        }
    }

    public Expr getWhereCondition() {
        return this.whereCondition;
    }

    Set<String> getUnusedParameters() {
        return this.unusedParameters;
    }
}

