/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Arrays;
import java.util.List;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.LogicValuedExpr;
import ru.curs.celesta.score.ParseException;

public final class Relop
extends LogicValuedExpr {
    public static final int GT = 0;
    public static final int LS = 1;
    public static final int GTEQ = 2;
    public static final int LSEQ = 3;
    public static final int NTEQ = 4;
    public static final int EQ = 5;
    public static final int LIKE = 6;
    static final String[] OPS = new String[]{" > ", " < ", " >= ", " <= ", " <> ", " = ", " LIKE "};
    private final Expr left;
    private final Expr right;
    private final int relop;

    public Relop(Expr left, Expr right, int relop) {
        if (relop < 0 || relop >= OPS.length) {
            throw new IllegalArgumentException();
        }
        this.left = left;
        this.right = right;
        this.relop = relop;
    }

    public Expr getLeft() {
        return this.left;
    }

    public Expr getRight() {
        return this.right;
    }

    public int getRelop() {
        return this.relop;
    }

    @Override
    public List<Expr> getAllOperands() {
        return Arrays.asList(this.getLeft(), this.getRight());
    }

    @Override
    public void accept(ExprVisitor visitor) throws ParseException {
        this.left.accept(visitor);
        this.right.accept(visitor);
        visitor.visitRelop(this);
    }
}

