/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableElement;

public final class StringColumn
extends Column<String> {
    public static final String VARCHAR = "VARCHAR";
    public static final String TEXT = "TEXT";
    private static final String INVALID_QUOTED_FORMAT = "Invalid quoted string format.";
    private String defaultvalue;
    private int length;
    private boolean max;

    public StringColumn(TableElement table, String name) throws ParseException {
        super(table, name);
    }

    @Override
    protected void setDefault(String lexvalue) throws ParseException {
        if (lexvalue == null) {
            this.defaultvalue = null;
            return;
        }
        this.defaultvalue = StringColumn.unquoteString(lexvalue);
    }

    public static String unquoteString(String lexvalue) throws ParseException {
        StringBuilder sb = new StringBuilder();
        int state = 0;
        block5: for (int i = 0; i < lexvalue.length(); ++i) {
            char c = lexvalue.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block5;
                    }
                    throw new ParseException(INVALID_QUOTED_FORMAT);
                }
                case 1: {
                    if (c == '\'') {
                        state = 2;
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == '\'') {
                        sb.append('\'');
                        state = 1;
                        continue block5;
                    }
                    throw new ParseException(INVALID_QUOTED_FORMAT);
                }
            }
        }
        return sb.toString();
    }

    public static String quoteString(String lexvalue) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        for (int i = 0; i < lexvalue.length(); ++i) {
            char c = lexvalue.charAt(i);
            sb.append(c);
            if (c != '\'') continue;
            sb.append('\'');
        }
        sb.append('\'');
        return sb.toString();
    }

    @Override
    public String getDefaultValue() {
        return this.defaultvalue;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isMax() {
        return this.max;
    }

    public void setLength(String length) throws ParseException {
        if ("MAX".equalsIgnoreCase(length)) {
            this.getParentTable().getGrain().modify();
            this.max = true;
            this.length = 0;
        } else {
            int newLength;
            this.max = false;
            try {
                newLength = Integer.parseInt(length);
            }
            catch (NumberFormatException e) {
                throw new ParseException(String.format("Invalid string column length '%s' for column '%s' of table '%s'", length, this.getName(), this.getParentTable().getName()));
            }
            if (newLength <= 0) {
                throw new ParseException(String.format("String column length for column '%s' must be greater than zero.", this.getName()));
            }
            this.getParentTable().getGrain().modify();
            this.length = newLength;
        }
    }

    @Override
    public String jdbcGetterName() {
        return "getString";
    }

    @Override
    public String getCelestaType() {
        return this.max ? TEXT : VARCHAR;
    }

    @Override
    public Class<?> getJavaClass() {
        return String.class;
    }

    @Override
    public String getCelestaDefault() {
        return this.defaultvalue == null ? null : StringColumn.quoteString(this.defaultvalue);
    }
}

