/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.score.ParseException;

public final class VersionString {
    public static final VersionString DEFAULT;
    private static final Pattern P;
    private final Map<String, Double> versions = new HashMap<String, Double>();
    private final String versionString;
    private final int hashCode;

    public VersionString(String versionString) throws ParseException {
        if (versionString == null) {
            throw new IllegalArgumentException();
        }
        if ("".equals(versionString)) {
            throw new ParseException("Empty grain version string.");
        }
        this.versionString = versionString;
        int h = 0;
        for (String version : versionString.split(",")) {
            Matcher m = P.matcher(version);
            if (!m.matches()) {
                throw new ParseException(String.format("Invalid grain version string: version component '%s' does not matches pattern '%s'", version, P.toString()));
            }
            this.versions.put(m.group(1), Double.parseDouble(m.group(2)));
            h ^= version.hashCode();
        }
        this.hashCode = h;
    }

    private int compareValues(Double v1, Double v2) {
        if (v1 == null && v2 == null) {
            throw new IllegalArgumentException();
        }
        if (v1 != null) {
            if (v2 == null || v2 < v1) {
                return 1;
            }
            if (v2 > v1) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public ComparisionState compareTo(VersionString o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> tags = new HashSet<String>();
        tags.addAll(this.versions.keySet());
        tags.addAll(o.versions.keySet());
        ComparisionState result = ComparisionState.EQUALS;
        for (String tag : tags) {
            int compare = this.compareValues(this.versions.get(tag), o.versions.get(tag));
            switch (result) {
                case EQUALS: {
                    if (compare > 0) {
                        result = ComparisionState.GREATER;
                        break;
                    }
                    if (compare >= 0) break;
                    result = ComparisionState.LOWER;
                    break;
                }
                case GREATER: {
                    if (compare >= 0) break;
                    result = ComparisionState.INCONSISTENT;
                    break;
                }
                case LOWER: {
                    if (compare <= 0) break;
                    result = ComparisionState.INCONSISTENT;
                    break;
                }
            }
            if (result != ComparisionState.INCONSISTENT) continue;
            break;
        }
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionString) {
            return this.compareTo((VersionString)obj) == ComparisionState.EQUALS;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.versionString;
    }

    static {
        VersionString v;
        P = Pattern.compile("([A-Z_]*)([0-9]+\\.[0-9]+)");
        try {
            v = new VersionString("1.00");
        }
        catch (ParseException e) {
            v = null;
        }
        DEFAULT = v;
    }

    public static enum ComparisionState {
        GREATER,
        EQUALS,
        LOWER,
        INCONSISTENT;

    }
}

