/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import ru.curs.celesta.score.Namespace;
import ru.curs.celesta.score.io.Resource;

public final class FileResource
implements Resource {
    private final File file;
    private final File canonicalFile;
    private final Namespace namespace;

    public FileResource(File file) {
        this(file, Namespace.DEFAULT);
    }

    public FileResource(File file, Namespace namespace) {
        this.file = file;
        this.canonicalFile = this.getCanonicalFile();
        this.namespace = Objects.requireNonNull(namespace);
    }

    private File getCanonicalFile() {
        try {
            return this.file.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        Files.createDirectories(this.file.toPath().getParent(), new FileAttribute[0]);
        return Files.newOutputStream(this.file.toPath(), new OpenOption[0]);
    }

    @Override
    public boolean delete() throws IOException {
        return Files.deleteIfExists(this.file.toPath());
    }

    @Override
    public boolean contains(Resource childResource) {
        if (!(childResource instanceof FileResource)) {
            return false;
        }
        File childFile = ((FileResource)childResource).file;
        try {
            return childFile.getCanonicalPath().startsWith(this.file.getCanonicalPath() + File.separator);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public String getRelativePath(Resource childResource) {
        if (!this.contains(childResource)) {
            return null;
        }
        File childFile = ((FileResource)childResource).file;
        return this.file.toPath().relativize(childFile.toPath()).toString();
    }

    @Override
    public Resource createRelative(String relativePath, Namespace namespace) throws IOException {
        return new FileResource(new File(this.file, relativePath), namespace);
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    public String toString() {
        return this.file.toString();
    }

    public int hashCode() {
        return this.canonicalFile != null ? this.canonicalFile.hashCode() : this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileResource other = (FileResource)obj;
        return this.canonicalFile != null && other.canonicalFile != null ? Objects.equals(this.canonicalFile, other.canonicalFile) : Objects.equals(this.file, other.file);
    }
}

