/*
 * Decompiled with CFR 0.152.
 */
package ru.homyakin.iuliia;

import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import ru.homyakin.iuliia.Schema;
import ru.homyakin.iuliia.Schemas;

public class Translator {
    private static final Pattern separator = Pattern.compile("\\b");
    private final Schema schema;

    public Translator(Schemas schema) {
        try {
            this.schema = schema.getSchema();
        }
        catch (IOException e) {
            throw new IllegalStateException("Resources were corrupted");
        }
    }

    public String translate(String str) {
        if (str == null) {
            return null;
        }
        String[] words = separator.split(str);
        StringBuilder translated = new StringBuilder();
        int length = words.length;
        for (int i = 0; i < length - 1; ++i) {
            translated.append(this.translateWord(words[i]));
        }
        translated.append(this.translateWord(words[length - 1]));
        return translated.toString();
    }

    private String translateWord(String word) {
        SplitWord splitWord = this.splitWord(word);
        Optional<String> translatedEnding = this.schema.translateEnding(splitWord.ending);
        return translatedEnding.map(s -> this.translateLetters(splitWord.stem) + s).orElseGet(() -> this.translateLetters(word));
    }

    private String translateLetters(String word) {
        String prev = "";
        String curr = "";
        String next = "";
        int length = word.length();
        StringBuilder translated = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (!curr.equals("")) {
                prev = curr;
            }
            curr = next.equals("") ? String.valueOf(word.charAt(i)) : next;
            next = i < length - 1 ? String.valueOf(word.charAt(i + 1)) : "";
            translated.append(this.schema.translateLetter(prev, curr, next));
        }
        return translated.toString();
    }

    private SplitWord splitWord(String word) {
        int endingLength = 2;
        if (word.length() > endingLength) {
            int separateIndex = word.length() - endingLength;
            return new SplitWord(word.substring(0, separateIndex), word.substring(separateIndex));
        }
        return new SplitWord(word, "");
    }

    private static class SplitWord {
        private final String stem;
        private final String ending;

        public SplitWord(String stem, String ending) {
            this.stem = stem;
            this.ending = ending;
        }
    }
}

