/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.async;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import ru.i_novus.ms.rdm.api.async.AsyncOperationResolver;
import ru.i_novus.ms.rdm.api.async.AsyncOperationTypeEnum;

@Component
public class AsyncOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AsyncOperationHandler.class);
    private static final String LOG_OPERATION_HANDLING = "Handle operation: type: {}, code: {}";
    private static final String LOG_OPERATION_HANDLING_ARGUMENTS = "Operation arguments:\n{}";
    private static final String LOG_OPERATION_TYPE_NOT_RESOLVED = "Operation type '%s' is not implemented";
    private final Collection<AsyncOperationResolver> resolvers;

    public AsyncOperationHandler(Collection<AsyncOperationResolver> resolvers) {
        this.resolvers = !CollectionUtils.isEmpty(resolvers) ? resolvers : Collections.emptyList();
    }

    public Serializable handle(AsyncOperationTypeEnum operationType, String code, Serializable[] args) {
        List satisfiedResolvers;
        logger.info(LOG_OPERATION_HANDLING, (Object)operationType, (Object)code);
        if (logger.isInfoEnabled()) {
            logger.info(LOG_OPERATION_HANDLING_ARGUMENTS, args != null ? Arrays.asList(args) : "");
        }
        if (CollectionUtils.isEmpty(satisfiedResolvers = this.resolvers.stream().filter(resolver -> resolver.isSatisfied(operationType)).collect(Collectors.toList()))) {
            String error = String.format(LOG_OPERATION_TYPE_NOT_RESOLVED, new Object[]{operationType});
            logger.error(error);
            return null;
        }
        if (satisfiedResolvers.size() == 1) {
            return ((AsyncOperationResolver)satisfiedResolvers.get(0)).resolve(code, args);
        }
        return (Serializable)((Object)satisfiedResolvers.stream().map(resolver -> resolver.resolve(code, args)).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

