/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.validation;

import io.swagger.annotations.ApiModel;
import java.util.Objects;
import net.n2oapp.platform.i18n.UserException;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidationType;

@ApiModel(parent=AttributeValidation.class)
public class PlainSizeAttributeValidation
extends AttributeValidation {
    private int size;

    public PlainSizeAttributeValidation() {
        super(AttributeValidationType.PLAIN_SIZE);
    }

    public PlainSizeAttributeValidation(int size) {
        this();
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public String valuesToString() {
        return String.valueOf(this.size);
    }

    @Override
    public PlainSizeAttributeValidation valueFromString(String value) {
        if (value == null || !value.matches("\\d+")) {
            throw new UserException("attribute.validation.value.invalid");
        }
        this.size = Integer.parseInt(value);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlainSizeAttributeValidation that = (PlainSizeAttributeValidation)o;
        return this.size == that.size;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.size);
    }
}

