/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.version;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ru.i_novus.ms.rdm.api.model.Structure;
import ru.i_novus.ms.rdm.api.model.UpdatableDto;
import ru.i_novus.ms.rdm.api.model.refdata.DraftChangeRequest;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidation;
import ru.i_novus.ms.rdm.api.model.version.UpdateValue;
import ru.i_novus.ms.rdm.api.util.TimeUtils;
import ru.i_novus.platform.datastorage.temporal.enums.FieldType;

@ApiModel(value="\u041c\u043e\u0434\u0435\u043b\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 \u0447\u0435\u0440\u043d\u043e\u0432\u0438\u043a\u0430", description="\u041d\u0430\u0431\u043e\u0440 \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 \u0447\u0435\u0440\u043d\u043e\u0432\u0438\u043a\u0430")
public class UpdateAttributeRequest
extends UpdatableDto
implements DraftChangeRequest {
    @ApiModelProperty(value="\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u043f\u0442\u0438\u043c\u0438\u0441\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0432\u0435\u0440\u0441\u0438\u0438-\u0447\u0435\u0440\u043d\u043e\u0432\u0438\u043a\u0430")
    private Integer optLockValue;
    @ApiModelProperty(value="\u041a\u043e\u0434 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
    private String code;
    @ApiModelProperty(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
    private UpdateValue<String> name;
    @ApiModelProperty(value="\u0422\u0438\u043f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
    private FieldType type;
    @ApiModelProperty(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0433\u043e \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
    private UpdateValue<Boolean> isPrimary;
    @ApiModelProperty(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0438\u043c\u043e\u0433\u043e \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
    private UpdateValue<Boolean> localizable;
    @ApiModelProperty(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
    private String description;
    @ApiModelProperty(value="\u041a\u043e\u0434 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f")
    private UpdateValue<String> attribute;
    @ApiModelProperty(value="\u041a\u043e\u0434 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u0441\u044b\u043b\u0430\u044e\u0442\u0441\u044f")
    private UpdateValue<String> referenceCode;
    @ApiModelProperty(value="\u0412\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0441\u044b\u043b\u043e\u0447\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f")
    private UpdateValue<String> displayExpression;
    @ApiParam(value="\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0434\u043b\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430")
    private List<AttributeValidation> validations;

    public UpdateAttributeRequest() {
    }

    public UpdateAttributeRequest(Integer optLockValue, Structure.Attribute attribute, Structure.Reference reference) {
        this.setLastActionDate(TimeUtils.nowZoned());
        this.optLockValue = optLockValue;
        this.code = attribute.getCode();
        this.type = attribute.getType();
        this.description = attribute.getDescription();
        UpdateAttributeRequest.setUpdateValueIfExists(attribute::getName, this::setName);
        UpdateAttributeRequest.setUpdateValueIfExists(attribute::getIsPrimary, this::setIsPrimary);
        UpdateAttributeRequest.setUpdateValueIfExists(attribute::getLocalizable, this::setLocalizable);
        if (reference == null) {
            return;
        }
        UpdateAttributeRequest.setUpdateValueIfExists(reference::getAttribute, this::setAttribute);
        UpdateAttributeRequest.setUpdateValueIfExists(reference::getReferenceCode, this::setReferenceCode);
        UpdateAttributeRequest.setUpdateValueIfExists(reference::getDisplayExpression, this::setDisplayExpression);
    }

    public UpdateAttributeRequest(Integer optLockValue, Structure.Attribute attribute, Structure.Reference reference, List<AttributeValidation> validations) {
        this(optLockValue, attribute, reference);
        this.validations = validations;
    }

    @Override
    public Integer getOptLockValue() {
        return this.optLockValue;
    }

    @Override
    public void setOptLockValue(Integer optLockValue) {
        this.optLockValue = optLockValue;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public UpdateValue<String> getName() {
        return this.name;
    }

    public void setName(UpdateValue<String> name) {
        this.name = name;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public UpdateValue<Boolean> getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(UpdateValue<Boolean> isPrimary) {
        this.isPrimary = isPrimary;
    }

    public UpdateValue<Boolean> getLocalizable() {
        return this.localizable;
    }

    public void setLocalizable(UpdateValue<Boolean> localizable) {
        this.localizable = localizable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateValue<String> getAttribute() {
        return this.attribute;
    }

    public void setAttribute(UpdateValue<String> attribute) {
        this.attribute = attribute;
    }

    public UpdateValue<String> getReferenceCode() {
        return this.referenceCode;
    }

    public void setReferenceCode(UpdateValue<String> referenceCode) {
        this.referenceCode = referenceCode;
    }

    public UpdateValue<String> getDisplayExpression() {
        return this.displayExpression;
    }

    public void setDisplayExpression(UpdateValue<String> displayExpression) {
        this.displayExpression = displayExpression;
    }

    public List<AttributeValidation> getValidations() {
        return this.validations;
    }

    public void setValidations(List<AttributeValidation> validations) {
        this.validations = validations;
    }

    public boolean hasIsPrimary() {
        return this.getIsPrimary() != null && this.getIsPrimary().isPresent() && Boolean.TRUE.equals(this.getIsPrimary().get());
    }

    public boolean isLocalizable() {
        return this.getLocalizable() != null && this.getLocalizable().isPresent() && Boolean.TRUE.equals(this.getLocalizable().get());
    }

    public boolean isReferenceType() {
        return FieldType.REFERENCE.equals((Object)this.getType());
    }

    public boolean isReferenceUpdating() {
        return UpdateAttributeRequest.isNullOrPresent(this.getAttribute()) && UpdateAttributeRequest.isNullOrPresent(this.getReferenceCode()) && UpdateAttributeRequest.isNullOrPresent(this.getDisplayExpression());
    }

    public boolean isReferenceFilling() {
        return UpdateAttributeRequest.isNotNullAndPresent(this.getAttribute()) && UpdateAttributeRequest.isNotNullAndPresent(this.getReferenceCode()) && UpdateAttributeRequest.isNotNullAndPresent(this.getDisplayExpression());
    }

    public void fillAttribute(Structure.Attribute attribute) {
        attribute.setType(this.getType());
        UpdateAttributeRequest.setValueIfExists(this::getName, attribute::setName);
        UpdateAttributeRequest.setValueIfExists(this::getIsPrimary, attribute::setIsPrimary);
        UpdateAttributeRequest.setValueIfExists(this::getLocalizable, attribute::setLocalizable);
        attribute.setDescription(this.getDescription());
    }

    public void fillReference(Structure.Reference reference) {
        UpdateAttributeRequest.setValueIfExists(this::getAttribute, reference::setAttribute);
        UpdateAttributeRequest.setValueIfExists(this::getReferenceCode, reference::setReferenceCode);
        UpdateAttributeRequest.setValueIfExists(this::getDisplayExpression, reference::setDisplayExpression);
    }

    private static <T extends Serializable> boolean isNotNullAndPresent(UpdateValue<T> value) {
        return value != null && value.isPresent();
    }

    private static <T extends Serializable> boolean isNullOrPresent(UpdateValue<T> value) {
        return value == null || value.isPresent();
    }

    private static <T extends Serializable> void setValueIfExists(Supplier<UpdateValue<T>> getter, Consumer<T> setter) {
        UpdateValue<T> value = getter.get();
        if (value != null) {
            setter.accept(value.isPresent() ? (Object)value.get() : null);
        }
    }

    public static <T extends Serializable> void setUpdateValueIfExists(Supplier<T> getter, Consumer<UpdateValue<T>> setter) {
        Serializable value = (Serializable)getter.get();
        if (value != null) {
            setter.accept(UpdateValue.of(value));
        }
    }
}

