/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.api.model.ExportFile;

@Provider
@Produces(value={"application/zip"})
public class ExportFileProvider
implements MessageBodyWriter<ExportFile>,
MessageBodyReader<ExportFile> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(ExportFile exportFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public void writeTo(ExportFile exportFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (InputStream inputStream = exportFile.getInputStream();
             OutputStream outputStream = entityStream;){
            httpHeaders.put((Object)"Content-Disposition", Collections.singletonList("attachment; filename=" + exportFile.getFileName()));
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public ExportFile readFrom(Class<ExportFile> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String name = null;
        try {
            name = null;
            List contentDisposition = (List)httpHeaders.get((Object)"Content-Disposition");
            String[] parts = new String[]{};
            if (contentDisposition != null && !contentDisposition.isEmpty()) {
                parts = ((String)contentDisposition.get(0)).split("filename[\\s]*=[\\s]*");
            }
            if (parts.length > 1) {
                name = parts[1].split(";")[0];
            }
            return new ExportFile(entityStream, name);
        }
        catch (Exception e) {
            entityStream.close();
            throw new RdmException(e);
        }
    }
}

