/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.util;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import ru.i_novus.ms.rdm.api.model.Structure;
import ru.i_novus.ms.rdm.api.model.compare.ComparableField;
import ru.i_novus.ms.rdm.api.model.compare.ComparableFieldValue;
import ru.i_novus.ms.rdm.api.model.compare.ComparableRow;
import ru.i_novus.ms.rdm.api.model.diff.RefBookAttributeDiff;
import ru.i_novus.ms.rdm.api.model.diff.RefBookDataDiff;
import ru.i_novus.ms.rdm.api.model.diff.StructureDiff;
import ru.i_novus.ms.rdm.api.model.field.ReferenceFilterValue;
import ru.i_novus.ms.rdm.api.model.refdata.RefBookRowValue;
import ru.i_novus.ms.rdm.api.model.version.AttributeFilter;
import ru.i_novus.ms.rdm.api.util.FieldValueUtils;
import ru.i_novus.platform.datastorage.temporal.enums.DiffStatusEnum;
import ru.i_novus.platform.datastorage.temporal.model.FieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.DiffFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.DiffRowValue;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;

public class ComparableUtils {
    private ComparableUtils() {
    }

    public static DiffStatusEnum getStrongestStatus(DiffStatusEnum status1, DiffStatusEnum status2) {
        if (status1 == DiffStatusEnum.DELETED || status2 == DiffStatusEnum.DELETED) {
            return DiffStatusEnum.DELETED;
        }
        if (status1 == DiffStatusEnum.INSERTED || status2 == DiffStatusEnum.INSERTED) {
            return DiffStatusEnum.INSERTED;
        }
        if (status1 == DiffStatusEnum.UPDATED || status2 == DiffStatusEnum.UPDATED) {
            return DiffStatusEnum.UPDATED;
        }
        return null;
    }

    public static DiffRowValue findDiffRowValue(List<Structure.Attribute> primaries, RowValue rowValue, List<DiffRowValue> diffRowValues) {
        return diffRowValues.stream().filter(diffRow -> primaries.stream().allMatch(primary -> {
            DiffFieldValue diffFieldValue = diffRow.getDiffFieldValue(primary.getCode());
            return diffFieldValue != null && Objects.equals(rowValue.getFieldValue(primary.getCode()).getValue(), FieldValueUtils.getDiffFieldValue(diffFieldValue, diffFieldValue.getStatus()));
        })).findFirst().orElse(null);
    }

    private static boolean isRefBookRowValue(List<Structure.Attribute> primaries, Structure.Attribute refAttribute, DiffRowValue diffRowValue, RefBookRowValue rowValue) {
        DiffFieldValue diffFieldValue = diffRowValue.getDiffFieldValue(primaries.get(0).getCode());
        return Objects.equals(FieldValueUtils.getDiffFieldValue(diffFieldValue, diffRowValue.getStatus()), FieldValueUtils.castFieldValue(rowValue.getFieldValue(refAttribute.getCode()), primaries.get(0).getType()));
    }

    public static RefBookRowValue findRefBookRowValue(List<Structure.Attribute> primaries, Structure.Attribute refAttribute, DiffRowValue diffRowValue, List<RefBookRowValue> rowValues) {
        return rowValues.stream().filter(rowValue -> ComparableUtils.isRefBookRowValue(primaries, refAttribute, diffRowValue, rowValue)).findFirst().orElse(null);
    }

    public static List<RefBookRowValue> findRefBookRowValues(List<Structure.Attribute> primaries, Structure.Attribute refAttribute, DiffRowValue diffRowValue, List<RefBookRowValue> rowValues) {
        return rowValues.stream().filter(rowValue -> ComparableUtils.isRefBookRowValue(primaries, refAttribute, diffRowValue, rowValue)).collect(Collectors.toList());
    }

    public static RowValue findRowValue(List<Structure.Attribute> primaries, RowValue rowValue, List<? extends RowValue> rowValues) {
        return rowValues.stream().filter(rowValue1 -> primaries.stream().allMatch(primary -> {
            FieldValue fieldValue = rowValue.getFieldValue(primary.getCode());
            FieldValue fieldValue1 = rowValue1.getFieldValue(primary.getCode());
            return fieldValue != null && fieldValue1 != null && fieldValue.getValue() != null && fieldValue.getValue().equals(fieldValue1.getValue());
        })).findFirst().orElse(null);
    }

    public static ComparableRow findComparableRow(List<Structure.Attribute> primaries, RowValue rowValue, List<ComparableRow> comparableRows, DiffStatusEnum status) {
        return comparableRows.stream().filter(comparableRow -> primaries.stream().allMatch(primary -> {
            ComparableFieldValue comparableValue = comparableRow.getComparableFieldValue(primary.getCode());
            return comparableValue != null && Objects.equals(FieldValueUtils.getCompareFieldValue(comparableValue, status), rowValue.getFieldValue(primary.getCode()).getValue());
        })).findFirst().orElse(null);
    }

    public static Set<List<AttributeFilter>> createPrimaryAttributesFilters(RefBookDataDiff refBookDataDiff, Structure structure) {
        return refBookDataDiff.getRows().getContent().stream().map(row -> structure.getPrimaries().stream().map(pk -> new AttributeFilter(pk.getCode(), FieldValueUtils.getDiffFieldValue(row.getDiffFieldValue(pk.getCode()), row.getStatus()), pk.getType())).collect(Collectors.toList())).collect(Collectors.toSet());
    }

    public static Set<List<AttributeFilter>> createPrimaryAttributesFilters(Page<? extends RowValue> data, Structure structure) {
        return data.getContent().stream().map(row -> structure.getPrimaries().stream().map(pk -> new AttributeFilter(pk.getCode(), row.getFieldValue(pk.getCode()).getValue(), pk.getType())).collect(Collectors.toList())).collect(Collectors.toSet());
    }

    public static List<ComparableField> createCommonComparableFields(RefBookAttributeDiff attributeDiff, Structure newStructure, Structure oldStructure) {
        List<ComparableField> comparableFields = newStructure.getAttributes().stream().map(attribute -> {
            DiffStatusEnum fieldStatus = null;
            if (attributeDiff.getUpdatedAttributes().contains(attribute.getCode())) {
                fieldStatus = DiffStatusEnum.UPDATED;
            }
            if (attributeDiff.getNewAttributes().contains(attribute.getCode())) {
                fieldStatus = DiffStatusEnum.INSERTED;
            }
            return new ComparableField(attribute.getCode(), attribute.getName(), fieldStatus);
        }).collect(Collectors.toList());
        attributeDiff.getOldAttributes().forEach(oldAttribute -> comparableFields.add(new ComparableField((String)oldAttribute, oldStructure.getAttribute((String)oldAttribute).getName(), DiffStatusEnum.DELETED)));
        return comparableFields;
    }

    public static boolean isRefBookAltered(StructureDiff diff) {
        return !diff.getInserted().isEmpty() || !diff.getDeleted().isEmpty() || diff.getUpdated().stream().anyMatch(updated -> !updated.getNewAttribute().getType().equals((Object)updated.getOldAttribute().getType()));
    }

    public static DiffRowValue findDiffRowValue(ReferenceFilterValue filterValue, List<DiffRowValue> diffRowValues) {
        return diffRowValues.stream().filter(diffRowValue -> {
            DiffFieldValue diffFieldValue = diffRowValue.getDiffFieldValue(filterValue.getAttribute().getCode());
            return Objects.nonNull(diffFieldValue) && Objects.equals(FieldValueUtils.getDiffFieldValue(diffFieldValue, diffRowValue.getStatus()), FieldValueUtils.castFieldValue((FieldValue)filterValue.getReferenceValue(), filterValue.getAttribute().getType()));
        }).findFirst().orElse(null);
    }
}

