/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ru.i_novus.ms.rdm.api.enumeration.ConflictType;
import ru.i_novus.platform.datastorage.temporal.enums.DiffStatusEnum;

public class ConflictUtils {
    private static final List<ConflictType> DATA_CONFLICT_TYPES = Arrays.asList(ConflictType.UPDATED, ConflictType.DELETED, ConflictType.ALTERED);
    private static final List<ConflictType> STRUCTURE_CONFLICT_TYPES = Collections.singletonList(ConflictType.DISPLAY_DAMAGED);

    private ConflictUtils() {
    }

    public static List<ConflictType> getDataConflictTypes() {
        return DATA_CONFLICT_TYPES;
    }

    public static List<ConflictType> getStructureConflictTypes() {
        return STRUCTURE_CONFLICT_TYPES;
    }

    public static ConflictType diffStatusToConflictType(DiffStatusEnum diffStatus) {
        if (diffStatus == null) {
            return null;
        }
        if (diffStatus.equals((Object)DiffStatusEnum.DELETED)) {
            return ConflictType.DELETED;
        }
        if (diffStatus.equals((Object)DiffStatusEnum.UPDATED)) {
            return ConflictType.UPDATED;
        }
        return null;
    }

    public static DiffStatusEnum conflictTypeToDiffStatus(ConflictType conflictType) {
        if (conflictType == null) {
            return null;
        }
        if (conflictType.equals((Object)ConflictType.DELETED)) {
            return DiffStatusEnum.DELETED;
        }
        if (conflictType.equals((Object)ConflictType.UPDATED) || conflictType.equals((Object)ConflictType.ALTERED)) {
            return DiffStatusEnum.UPDATED;
        }
        return null;
    }
}

