/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.validation;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidationType;
import ru.i_novus.ms.rdm.api.model.validation.DateRangeAttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.FloatRangeAttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.FloatSizeAttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.IntRangeAttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.PlainSizeAttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.RegExpAttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.RequiredAttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.UniqueAttributeValidation;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=RequiredAttributeValidation.class, name="REQUIRED"), @JsonSubTypes.Type(value=UniqueAttributeValidation.class, name="UNIQUE"), @JsonSubTypes.Type(value=PlainSizeAttributeValidation.class, name="PLAIN_SIZE"), @JsonSubTypes.Type(value=FloatSizeAttributeValidation.class, name="FLOAT_SIZE"), @JsonSubTypes.Type(value=IntRangeAttributeValidation.class, name="INT_RANGE"), @JsonSubTypes.Type(value=FloatRangeAttributeValidation.class, name="FLOAT_RANGE"), @JsonSubTypes.Type(value=DateRangeAttributeValidation.class, name="DATE_RANGE"), @JsonSubTypes.Type(value=RegExpAttributeValidation.class, name="REG_EXP")})
public abstract class AttributeValidation
implements Serializable {
    @ApiModelProperty(accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private Integer versionId;
    @ApiModelProperty(accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String attribute;
    private AttributeValidationType type;

    public AttributeValidation(AttributeValidationType type) {
        this.type = type;
    }

    public Integer getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Integer versionId) {
        this.versionId = versionId;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public AttributeValidationType getType() {
        return this.type;
    }

    public void setType(AttributeValidationType type) {
        this.type = type;
    }

    public abstract String valuesToString();

    public abstract AttributeValidation valueFromString(String var1);

    public static AttributeValidation of(String stype, String val) {
        return AttributeValidation.ofTypeWithAttr(stype, val, null);
    }

    public static AttributeValidation ofTypeWithAttr(String stype, String val, String attr) {
        AttributeValidationType type = AttributeValidationType.valueOf(stype.toUpperCase());
        AttributeValidation validation = type.getValidationInstance().valueFromString(val);
        validation.setAttribute(attr);
        return validation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeValidation that = (AttributeValidation)o;
        return Objects.equals(this.versionId, that.versionId) && Objects.equals(this.attribute, that.attribute) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.versionId, this.attribute, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AttributeValidation{");
        sb.append("versionId=").append(this.versionId);
        sb.append(", attribute='").append(this.attribute).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", values='").append(this.valuesToString()).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

