/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.model.validation;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import net.n2oapp.platform.i18n.UserException;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidation;
import ru.i_novus.ms.rdm.api.model.validation.AttributeValidationType;

public class IntRangeAttributeValidation
extends AttributeValidation {
    private BigInteger min;
    private BigInteger max;

    public IntRangeAttributeValidation() {
        super(AttributeValidationType.INT_RANGE);
    }

    public IntRangeAttributeValidation(BigInteger min, BigInteger max) {
        this();
        this.min = min;
        this.max = max;
    }

    public BigInteger getMin() {
        return this.min;
    }

    public void setMin(BigInteger min) {
        this.min = min;
    }

    public BigInteger getMax() {
        return this.max;
    }

    public void setMax(BigInteger max) {
        this.max = max;
    }

    @Override
    public String valuesToString() {
        return (Serializable)(this.min != null ? this.min : "") + ";" + (Serializable)(this.max != null ? this.max : "");
    }

    @Override
    public IntRangeAttributeValidation valueFromString(String value) {
        if (value == null || !value.matches("(-?\\d+)?;(-?\\d+)?")) {
            throw new UserException("attribute.validation.value.invalid");
        }
        String[] split = value.split(";");
        if (!StringUtils.isEmpty((Object)split[0])) {
            this.min = new BigInteger(split[0]);
        }
        if (!StringUtils.isEmpty((Object)split[1])) {
            this.max = new BigInteger(split[1]);
        }
        if (this.min != null && this.max != null && this.min.compareTo(this.max) > 0) {
            throw new UserException("invalid.range");
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntRangeAttributeValidation that = (IntRangeAttributeValidation)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.min, this.max);
    }
}

