/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.api.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.model.Structure;
import ru.i_novus.ms.rdm.api.model.compare.ComparableFieldValue;
import ru.i_novus.ms.rdm.api.model.field.ReferenceFilterValue;
import ru.i_novus.ms.rdm.api.model.refdata.RefBookRowValue;
import ru.i_novus.ms.rdm.api.model.version.AttributeFilter;
import ru.i_novus.ms.rdm.api.util.TimeUtils;
import ru.i_novus.platform.datastorage.temporal.enums.DiffStatusEnum;
import ru.i_novus.platform.datastorage.temporal.enums.FieldType;
import ru.i_novus.platform.datastorage.temporal.model.DisplayExpression;
import ru.i_novus.platform.datastorage.temporal.model.FieldValue;
import ru.i_novus.platform.datastorage.temporal.model.LongRowValue;
import ru.i_novus.platform.datastorage.temporal.model.Reference;
import ru.i_novus.platform.datastorage.temporal.model.criteria.SearchTypeEnum;
import ru.i_novus.platform.datastorage.temporal.model.value.BooleanFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.DateFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.DiffFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.FloatFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.IntegerFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.ReferenceFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;
import ru.i_novus.platform.datastorage.temporal.model.value.StringFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.TreeFieldValue;

public class FieldValueUtils {
    private static final String PRIMARY_KEY_VALUE_DISPLAY_DELIMITER = ": ";

    private FieldValueUtils() {
        throw new UnsupportedOperationException();
    }

    public static String toDisplayValue(String displayExpression, RowValue rowValue, List<String> primaryKeyCodes) {
        return FieldValueUtils.toDisplayValue(displayExpression, ((LongRowValue)rowValue).getFieldValues(), primaryKeyCodes);
    }

    private static String toDisplayValue(String displayExpression, List<FieldValue> fieldValues, List<String> primaryKeyCodes) {
        Map placeholders = new DisplayExpression(displayExpression).getPlaceholders();
        HashMap<String, Object> map = new HashMap<String, Object>();
        fieldValues.forEach(fieldValue -> map.put(fieldValue.getField(), FieldValueUtils.toPlaceholderValue(fieldValue, placeholders)));
        List<String> absentPlaceholders = placeholders.keySet().stream().filter(placeholder -> Objects.isNull(map.get(placeholder))).collect(Collectors.toList());
        absentPlaceholders.forEach(absent -> map.put((String)absent, ""));
        Object displayValue = FieldValueUtils.createDisplayExpressionSubstitutor(map).replace(displayExpression);
        if (!CollectionUtils.isEmpty(primaryKeyCodes) && !CollectionUtils.containsAny(placeholders.keySet(), primaryKeyCodes)) {
            String primaryKeysValue = primaryKeyCodes.stream().map(code -> String.valueOf(map.get(code))).filter(value -> !StringUtils.isEmpty((Object)value)).reduce("", (result, value) -> result + value + PRIMARY_KEY_VALUE_DISPLAY_DELIMITER);
            displayValue = primaryKeysValue + (String)displayValue;
        }
        return displayValue;
    }

    private static String toPlaceholderValue(FieldValue fieldValue, Map<String, String> placeholders) {
        if (fieldValue.getValue() != null) {
            return String.valueOf(fieldValue.getValue());
        }
        String value = placeholders.get(fieldValue.getField());
        return value != null ? value : "";
    }

    public static Serializable castFieldValue(FieldValue fieldValue, FieldType toFieldType) {
        if (fieldValue instanceof ReferenceFieldValue) {
            return FieldValueUtils.castReferenceFieldValue((Reference)fieldValue.getValue(), toFieldType);
        }
        return fieldValue.getValue();
    }

    private static Serializable castReferenceFieldValue(Reference value, FieldType toFieldType) {
        return value.getValue() == null || toFieldType == null ? null : FieldValueUtils.castReferenceValue(value.getValue(), toFieldType);
    }

    public static Serializable castReferenceValue(String value, FieldType toFieldType) {
        return switch (toFieldType) {
            case FieldType.INTEGER -> new BigInteger(value);
            case FieldType.FLOAT -> Float.valueOf(Float.parseFloat(value));
            case FieldType.DATE -> LocalDate.parse(value, TimeUtils.DATE_PATTERN_ERA_FORMATTER);
            case FieldType.BOOLEAN -> Boolean.valueOf(value);
            default -> value;
        };
    }

    public static List<FieldValue> getRowPrimaryValues(RefBookRowValue rowValue, Structure structure) {
        if (rowValue == null || structure == null) {
            return Collections.emptyList();
        }
        return rowValue.getFieldValues().stream().filter(fieldValue -> structure.getAttribute(fieldValue.getField()).getIsPrimary()).collect(Collectors.toList());
    }

    public static Set<List<AttributeFilter>> toAttributeFilters(List<ReferenceFilterValue> filterValues) {
        return filterValues.stream().map(value -> {
            FieldType attributeType = value.getAttribute().getType();
            Serializable attributeValue = FieldValueUtils.castFieldValue((FieldValue)value.getReferenceValue(), attributeType);
            return new AttributeFilter(value.getAttribute().getCode(), attributeValue, attributeType, SearchTypeEnum.EXACT);
        }).map(Collections::singletonList).collect(Collectors.toSet());
    }

    public static Serializable getDiffFieldValue(DiffFieldValue fieldValue, DiffStatusEnum status) {
        return DiffStatusEnum.DELETED.equals((Object)status) ? (Serializable)fieldValue.getOldValue() : (Serializable)fieldValue.getNewValue();
    }

    public static Object getCompareFieldValue(ComparableFieldValue fieldValue, DiffStatusEnum status) {
        return DiffStatusEnum.DELETED.equals((Object)status) ? fieldValue.getOldValue() : fieldValue.getNewValue();
    }

    public static FieldValue toFieldValueByType(Object value, String fieldCode, FieldType fieldType) {
        return switch (fieldType) {
            case FieldType.STRING -> new StringFieldValue(fieldCode, (String)value);
            case FieldType.INTEGER -> new IntegerFieldValue(fieldCode, (BigInteger)value);
            case FieldType.REFERENCE -> new ReferenceFieldValue(fieldCode, (Reference)value);
            case FieldType.FLOAT -> new FloatFieldValue(fieldCode, (Number)((BigDecimal)value));
            case FieldType.BOOLEAN -> new BooleanFieldValue(fieldCode, (Boolean)value);
            case FieldType.DATE -> new DateFieldValue(fieldCode, (LocalDate)value);
            case FieldType.TREE -> new TreeFieldValue(fieldCode, (String)value);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static String diffValuesToDisplayValue(String displayExpression, List<DiffFieldValue> diffFieldValues, DiffStatusEnum diffStatus) {
        HashMap<String, Object> map = new HashMap<String, Object>(diffFieldValues.size());
        diffFieldValues.forEach(fieldValue -> map.put(fieldValue.getField().getName(), FieldValueUtils.getDiffFieldValue(fieldValue, diffStatus)));
        return FieldValueUtils.createDisplayExpressionSubstitutor(map).replace(displayExpression);
    }

    public static StringSubstitutor createDisplayExpressionSubstitutor(Map<String, Object> map) {
        StringSubstitutor substitutor = new StringSubstitutor(map, "${", "}");
        substitutor.setValueDelimiter(":");
        return substitutor;
    }
}

