/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.fnsi.sync.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.web.client.RestTemplate;
import ru.i_novus.ms.fnsi.sync.impl.FnsiSyncSourceService;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSource;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceServiceFactory;

public class FnsiSyncSourceServiceFactory
implements SyncSourceServiceFactory {
    private final RestTemplate restTemplate;
    private final ObjectMapper mapper;

    public FnsiSyncSourceServiceFactory(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.mapper = new ObjectMapper();
    }

    public SyncSourceService createService(SyncSource source) {
        Map initValues = null;
        try {
            initValues = (Map)this.mapper.readValue(source.getInitValues(), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
        String userKey = (String)initValues.get("userKey");
        String fnsiUrl = (String)initValues.get("url");
        return new FnsiSyncSourceService(this.restTemplate, fnsiUrl, userKey);
    }

    public boolean isSatisfied(SyncSource source) {
        return source.getFactoryName().equals("FnsiSyncSourceServiceFactory");
    }
}

