/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.dao.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.api.util.StringUtils;
import ru.i_novus.ms.rdm.sync.dao.builder.SqlClauseBuilder;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.model.filter.FieldValueFilter;

public class SqlValueFilterBuilder
extends SqlClauseBuilder {
    private static final String OPERATOR_LIKE = "LIKE";
    private static final String OPERATOR_ILIKE = "ILIKE";

    public SqlValueFilterBuilder() {
    }

    public SqlValueFilterBuilder(List<String> clauses, Map<String, Serializable> params) {
        super(clauses, params);
    }

    @Override
    public String build() {
        return this.collect(Collectors.joining("\n OR "));
    }

    public void parse(String field, DataTypeEnum type, String bindName, FieldValueFilter filter) {
        if (org.springframework.util.StringUtils.isEmpty((Object)field) || org.springframework.util.StringUtils.isEmpty((Object)bindName) || filter == null || filter.isEmpty()) {
            return;
        }
        String fieldName = StringUtils.addDoubleQuotes((String)field);
        switch (filter.getType()) {
            case EQUAL: {
                this.parseEqual(fieldName, bindName, filter.getValues());
                break;
            }
            case LIKE: {
                this.parseLike(fieldName, type, bindName, filter.getValues());
                break;
            }
            case ILIKE: {
                this.parseILike(fieldName, type, bindName, filter.getValues());
                break;
            }
            case QLIKE: {
                this.parseQLike(fieldName, type, bindName, filter.getValues());
                break;
            }
            case IQLIKE: {
                this.parseIQLike(fieldName, type, bindName, filter.getValues());
                break;
            }
            case IS_NULL: {
                this.parseIsNull(fieldName);
                break;
            }
            case IS_NOT_NULL: {
                this.parseIsNotNull(fieldName);
                break;
            }
            default: {
                throw new RdmException("Unknown type '" + filter.getType() + "' of field value filter");
            }
        }
    }

    private void parseEqual(String field, String bindName, List<? extends Serializable> values) {
        if (values.size() == 1) {
            this.append(field + " = :" + bindName);
            this.bind(bindName, values.get(0));
        } else {
            this.append(field + " IN (:" + bindName + ")");
            this.bind(bindName, new ArrayList<Serializable>(values));
        }
    }

    private void parseLike(String field, DataTypeEnum type, String bindName, List<? extends Serializable> values) {
        this.parseLike(this.getStringFieldSubst(field, type), bindName, OPERATOR_LIKE, values);
    }

    private void parseILike(String field, DataTypeEnum type, String bindName, List<? extends Serializable> values) {
        this.parseLike(this.getStringFieldSubst(field, type), bindName, OPERATOR_ILIKE, values);
    }

    private void parseQLike(String field, DataTypeEnum type, String bindName, List<? extends Serializable> values) {
        this.parseLike(this.getQuotesIgnoredFieldSubst(field, type), bindName, OPERATOR_LIKE, values);
    }

    private void parseIQLike(String field, DataTypeEnum type, String bindName, List<? extends Serializable> values) {
        this.parseLike(this.getQuotesIgnoredFieldSubst(field, type), bindName, OPERATOR_ILIKE, values);
    }

    private void parseLike(String fieldSubst, String bindName, String operator, List<? extends Serializable> values) {
        IntStream.range(0, values.size()).forEach(index -> {
            Serializable value = (Serializable)values.get(index);
            String indexName = bindName + "_" + index;
            String valueName = value instanceof String ? indexName : indexName + "::text";
            this.append(fieldSubst + " " + operator + " '%' || :" + valueName + " || '%'");
            this.bind(indexName, (Serializable)values.get(index));
        });
    }

    private void parseIsNull(String field) {
        this.parseIs(field, "NULL");
    }

    private void parseIsNotNull(String field) {
        this.parseIs(field, "NOT NULL");
    }

    private void parseIs(String field, String value) {
        this.append(field + " IS " + value);
    }

    private String getStringFieldSubst(String field, DataTypeEnum type) {
        return type == DataTypeEnum.VARCHAR ? field : field + "::text";
    }

    private String getQuotesIgnoredFieldSubst(String field, DataTypeEnum type) {
        return type == DataTypeEnum.VARCHAR ? this.getCharsIgnoredSubst(field, "'\"") : field + "::text";
    }

    private String getCharsIgnoredSubst(String field, String chars) {
        if (org.springframework.util.StringUtils.isEmpty((Object)chars)) {
            return field;
        }
        chars = org.springframework.util.StringUtils.replace((String)chars, (String)"'", (String)"''");
        return "translate(" + field + ", '" + chars + "', '')";
    }
}

