/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.api.util.TimeUtils;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.model.filter.FilterTypeEnum;

public enum DataTypeEnum {
    VARCHAR(Arrays.asList("varchar", "text", "character varying")),
    INTEGER(Arrays.asList("integer", "smallint", "bigint", "serial", "bigserial")),
    DATE(Collections.singletonList("date")),
    BOOLEAN(Collections.singletonList("boolean")),
    FLOAT(Arrays.asList("decimal", "numeric")),
    JSONB(Collections.singletonList("jsonb"));

    private static final Map<String, DataTypeEnum> DATA_TYPE_MAP;
    private final List<String> dataTypes;

    private DataTypeEnum(List<String> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<String> getDataTypes() {
        return this.dataTypes;
    }

    public List<Serializable> toValues(List<String> list) {
        return switch (this) {
            case BOOLEAN -> list.stream().map(Boolean::valueOf).collect(Collectors.toList());
            case INTEGER -> list.stream().map(BigInteger::new).collect(Collectors.toList());
            case FLOAT -> list.stream().map(BigDecimal::new).collect(Collectors.toList());
            case DATE -> list.stream().map(TimeUtils::parseLocalDate).collect(Collectors.toList());
            case VARCHAR -> new ArrayList<String>(list);
            default -> throw new RdmException("Cast from string to " + this.name() + " not supported.");
        };
    }

    public Serializable toValue(String s) {
        return this.toValues(Collections.singletonList(s)).get(0);
    }

    public Map<FilterTypeEnum, List<Serializable>> toMap(List<String> list) {
        HashMap<FilterTypeEnum, List<Serializable>> result = new HashMap<FilterTypeEnum, List<Serializable>>(FilterTypeEnum.size());
        FilterTypeEnum.list().forEach(type -> result.put((FilterTypeEnum)((Object)type), new ArrayList(list.size())));
        switch (this) {
            case BOOLEAN: {
                this.addListValues(list, Boolean::valueOf, result);
                break;
            }
            case INTEGER: {
                this.addListValues(list, BigInteger::new, result);
                break;
            }
            case FLOAT: {
                this.addListValues(list, BigDecimal::new, result);
                break;
            }
            case DATE: {
                this.addListValues(list, TimeUtils::parseLocalDate, result);
                break;
            }
            case VARCHAR: {
                this.addListValues(list, this::fromString, result);
                break;
            }
            default: {
                throw new RdmException("Cast from string to " + this.name() + " not supported.");
            }
        }
        return result;
    }

    private Serializable fromString(String value) {
        return StringUtils.isEmpty((Object)value) ? null : value;
    }

    private void addListValues(List<String> list, Function<String, Serializable> converter, Map<FilterTypeEnum, List<Serializable>> result) {
        list.stream().filter(item -> !StringUtils.isEmpty((Object)item)).forEach(item -> this.addItemValue((String)item, converter, result));
    }

    private void addItemValue(String item, Function<String, Serializable> converter, Map<FilterTypeEnum, List<Serializable>> result) {
        String value;
        int index = item.indexOf("$") == 0 ? item.indexOf("|", 1) : -1;
        String mask = index > 0 ? item.substring(1, index) : FilterTypeEnum.EQUAL.getMask();
        FilterTypeEnum filterType = FilterTypeEnum.fromMask(mask);
        if (filterType == null) {
            return;
        }
        Serializable filterValue = null;
        if (filterType.isValued() && (filterValue = converter.apply(value = index > 0 ? item.substring(index + 1) : item)) == null) {
            return;
        }
        result.get((Object)filterType).add(filterValue);
    }

    public static DataTypeEnum getByDataType(String dataType) {
        return dataType == null ? null : DATA_TYPE_MAP.get(dataType);
    }

    public static DataTypeEnum getByRdmAttr(AttributeTypeEnum type) {
        return switch (type) {
            case AttributeTypeEnum.DATE -> DATE;
            case AttributeTypeEnum.FLOAT -> FLOAT;
            case AttributeTypeEnum.INTEGER -> INTEGER;
            case AttributeTypeEnum.STRING, AttributeTypeEnum.REFERENCE -> VARCHAR;
            case AttributeTypeEnum.BOOLEAN -> BOOLEAN;
            default -> throw new RdmException(String.format("Attribute type '%s' is not supported", type));
        };
    }

    static {
        DATA_TYPE_MAP = new HashMap<String, DataTypeEnum>();
        for (DataTypeEnum type : DataTypeEnum.values()) {
            for (String dataType : type.dataTypes) {
                DATA_TYPE_MAP.put(dataType, type);
            }
        }
    }
}

