/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.model.filter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum FilterTypeEnum {
    EQUAL("eq"),
    LIKE("like"),
    ILIKE("like/i"),
    QLIKE("like/q"),
    IQLIKE("like/iq"),
    IS_NULL("null"),
    IS_NOT_NULL("not-null");

    private static final List<FilterTypeEnum> TYPE_LIST;
    private static final Map<String, FilterTypeEnum> MASK_MAP;
    private static final Set<FilterTypeEnum> NON_VALUED;
    private final String mask;

    private FilterTypeEnum(String mask) {
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }

    public static FilterTypeEnum fromMask(String mask) {
        return mask != null ? MASK_MAP.get(mask) : null;
    }

    public boolean isValued() {
        return !NON_VALUED.contains((Object)this);
    }

    public static int size() {
        return TYPE_LIST.size();
    }

    public static List<FilterTypeEnum> list() {
        return TYPE_LIST;
    }

    static {
        TYPE_LIST = Arrays.asList(FilterTypeEnum.values());
        MASK_MAP = new HashMap<String, FilterTypeEnum>();
        for (FilterTypeEnum type : FilterTypeEnum.values()) {
            MASK_MAP.put(type.mask, type);
        }
        NON_VALUED = Set.of(IS_NULL, IS_NOT_NULL);
    }
}

