/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.service.LocalRdmDataService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.dao.criteria.DeletedCriteria;
import ru.i_novus.ms.rdm.sync.dao.criteria.LocalDataCriteria;
import ru.i_novus.ms.rdm.sync.dao.criteria.VersionedLocalDataCriteria;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.model.filter.FieldFilter;
import ru.i_novus.ms.rdm.sync.model.filter.FieldValueFilter;
import ru.i_novus.ms.rdm.sync.model.filter.FilterTypeEnum;

@Service
public class LocalRdmDataServiceImpl
implements LocalRdmDataService {
    @Autowired
    private RdmSyncDao dao;

    public Page<Map<String, Object>> getData(String refBookCode, Boolean getDeleted, Integer page, Integer size, @Context UriInfo uriInfo) {
        VersionMapping versionMapping = this.getVersionMappingOrThrowRefBookNotFound(refBookCode);
        if (page == null) {
            page = 0;
        }
        if (size == null) {
            size = 10;
        }
        List<FieldFilter> filters = this.paramsToFilters(this.dao.getFieldMappings(versionMapping.getId()), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        LocalDataCriteria localDataCriteria = new LocalDataCriteria(versionMapping.getTable(), versionMapping.getPrimaryField(), size, page * size, filters);
        DeletedCriteria deleted = new DeletedCriteria(versionMapping.getDeletedField(), Boolean.TRUE.equals(getDeleted));
        localDataCriteria.setDeleted(deleted);
        localDataCriteria.setSysPkColumn(versionMapping.getSysPkColumn());
        return this.dao.getData(localDataCriteria);
    }

    public Page<Map<String, Object>> getVersionedData(String refBookCode, String version, Integer page, Integer size, UriInfo uriInfo) {
        VersionMapping versionMapping = this.getVersionMappingOrThrowRefBookNotFound(refBookCode);
        if (page == null) {
            page = 0;
        }
        if (size == null) {
            size = 10;
        }
        List<FieldFilter> filters = this.paramsToFilters(this.dao.getFieldMappings(versionMapping.getId()), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        VersionedLocalDataCriteria criteria = new VersionedLocalDataCriteria(versionMapping.getTable(), versionMapping.getPrimaryField(), size, page * size, filters, version);
        return this.dao.getSimpleVersionedData(criteria);
    }

    public Map<String, Object> getSingle(String refBookCode, String primaryKey) {
        VersionMapping versionMapping = this.getVersionMappingOrThrowRefBookNotFound(refBookCode);
        FieldMapping fieldMapping = this.dao.getFieldMappings(versionMapping.getId()).stream().filter(fm -> fm.getSysField().equals(versionMapping.getPrimaryField())).findFirst().orElseThrow(() -> new RdmException(versionMapping.getPrimaryField() + " not found in RefBook with code " + refBookCode));
        DataTypeEnum fieldType = DataTypeEnum.getByDataType(fieldMapping.getSysDataType());
        Serializable primaryValue = fieldType.toValue(primaryKey);
        FieldFilter primaryFilter = new FieldFilter(versionMapping.getPrimaryField(), fieldType, Collections.singletonList(new FieldValueFilter(FilterTypeEnum.EQUAL, Collections.singletonList(primaryValue))));
        LocalDataCriteria localDataCriteria = new LocalDataCriteria(versionMapping.getTable(), versionMapping.getPrimaryField(), 1, 0, Collections.singletonList(primaryFilter));
        Page<Map<String, Object>> page = this.dao.getData(localDataCriteria);
        return (Map)page.get().findAny().orElseThrow(NotFoundException::new);
    }

    private List<FieldFilter> paramsToFilters(List<FieldMapping> fieldMappings, MultivaluedMap<String, String> params) {
        Map<String, DataTypeEnum> fieldTypeMap = fieldMappings.stream().collect(Collectors.toMap(FieldMapping::getSysField, fm -> DataTypeEnum.getByDataType(fm.getSysDataType())));
        return params.entrySet().stream().filter(param -> fieldTypeMap.get(param.getKey()) != null).map(param -> this.paramToFilter((Map.Entry<String, List<String>>)param, (DataTypeEnum)((Object)((Object)fieldTypeMap.get(param.getKey()))))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, Object> getBySystemId(String refBookCode, Long recordId) {
        VersionMapping versionMapping = this.getVersionMappingOrThrowRefBookNotFound(refBookCode);
        LocalDataCriteria localDataCriteria = new LocalDataCriteria(versionMapping.getTable(), versionMapping.getPrimaryField(), 1, 0, null);
        localDataCriteria.setRecordId(recordId);
        localDataCriteria.setSysPkColumn(versionMapping.getSysPkColumn());
        Page<Map<String, Object>> synced = this.dao.getData(localDataCriteria);
        return (Map)synced.get().findAny().orElseThrow(NotFoundException::new);
    }

    private FieldFilter paramToFilter(Map.Entry<String, List<String>> param, DataTypeEnum fieldType) {
        Map<FilterTypeEnum, List<Serializable>> valueListMap = fieldType.toMap(param.getValue());
        List<FieldValueFilter> valueFilters = valueListMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).map(FieldValueFilter::new).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(valueFilters) ? new FieldFilter(param.getKey(), fieldType, valueFilters) : null;
    }

    private VersionMapping getVersionMappingOrThrowRefBookNotFound(String refBookCode) {
        VersionMapping versionMapping = this.dao.getVersionMapping(refBookCode, "CURRENT");
        if (versionMapping == null) {
            throw new RdmException("RefBook with code '" + refBookCode + "' is not maintained in system.");
        }
        return versionMapping;
    }
}

