/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.service.RdmMappingService;
import ru.i_novus.platform.datastorage.temporal.enums.FieldType;
import ru.i_novus.platform.datastorage.temporal.model.Reference;

public class RdmMappingServiceImpl
implements RdmMappingService {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter ISO_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter EU_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    @Override
    public Object map(AttributeTypeEnum attributeType, DataTypeEnum clientType, Object value) {
        if (value == null) {
            return AttributeTypeEnum.BOOLEAN.equals((Object)attributeType) ? this.mapBoolean(clientType, value) : null;
        }
        Object result = null;
        switch (attributeType) {
            case STRING: {
                return this.mapVarchar(clientType, value);
            }
            case INTEGER: {
                return this.mapInteger(clientType, value);
            }
            case BOOLEAN: {
                return this.mapBoolean(clientType, value);
            }
            case FLOAT: {
                return this.mapFloat(clientType, value);
            }
            case DATE: {
                return this.mapDate(clientType, value);
            }
            case TREE: {
                return value.toString();
            }
            case REFERENCE: {
                return this.mapReference(clientType, value);
            }
        }
        return result;
    }

    private Object mapInteger(DataTypeEnum clientType, Object value) {
        switch (clientType) {
            case INTEGER: {
                return new BigInteger(value.toString());
            }
            case VARCHAR: {
                return value.toString();
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value.toString()));
            }
        }
        throw new ClassCastException(this.getClassCastError(FieldType.INTEGER, clientType, value));
    }

    private Object mapVarchar(DataTypeEnum clientType, Object value) {
        String valueStr = value.toString();
        switch (clientType) {
            case VARCHAR: {
                return value;
            }
            case INTEGER: {
                return new BigInteger(valueStr);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(valueStr));
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(valueStr);
            }
            case DATE: {
                DateTimeFormatter dateTimeFormatter = valueStr.contains(".") ? EU_DATE_FORMATTER : ISO_DATE_FORMATTER;
                return LocalDate.parse(valueStr, dateTimeFormatter);
            }
        }
        throw new ClassCastException(this.getClassCastError(FieldType.STRING, clientType, value));
    }

    private Object mapDate(DataTypeEnum clientType, Object value) {
        if (clientType.equals((Object)DataTypeEnum.DATE)) {
            if (value instanceof LocalDate) {
                return value;
            }
            if (value instanceof java.sql.Date) {
                return ((java.sql.Date)value).toLocalDate();
            }
            if (value instanceof Date) {
                return ((Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            return LocalDate.parse(value.toString(), ISO_DATE_FORMATTER);
        }
        if (clientType.equals((Object)DataTypeEnum.VARCHAR)) {
            if (value instanceof Date) {
                return FastDateFormat.getInstance((String)DATE_FORMAT).format(value);
            }
            if (value instanceof LocalDate || value instanceof LocalDateTime) {
                return ISO_DATE_FORMATTER.format((Temporal)value);
            }
            throw new ClassCastException(this.getClassCastError(FieldType.DATE, clientType, value));
        }
        throw new ClassCastException(this.getClassCastError(FieldType.DATE, clientType, value));
    }

    private Object mapBoolean(DataTypeEnum clientType, Object value) {
        if (value == null) {
            value = "false";
        }
        if (clientType.equals((Object)DataTypeEnum.VARCHAR)) {
            return value.toString();
        }
        if (clientType.equals((Object)DataTypeEnum.BOOLEAN)) {
            return Boolean.parseBoolean(value.toString());
        }
        throw new ClassCastException(this.getClassCastError(FieldType.BOOLEAN, clientType, value));
    }

    private Object mapFloat(DataTypeEnum clientType, Object value) {
        if (clientType.equals((Object)DataTypeEnum.VARCHAR)) {
            return value.toString();
        }
        if (clientType.equals((Object)DataTypeEnum.FLOAT)) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        throw new ClassCastException(this.getClassCastError(FieldType.FLOAT, clientType, value));
    }

    private Object mapReference(DataTypeEnum clientType, Object value) {
        String refValue;
        Reference reference = null;
        if (value instanceof Reference) {
            reference = (Reference)value;
            refValue = reference.getValue();
        } else {
            if (value == null) {
                return null;
            }
            refValue = value.toString();
        }
        switch (clientType) {
            case VARCHAR: {
                return refValue;
            }
            case INTEGER: {
                return new BigInteger(refValue);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(refValue));
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(refValue);
            }
            case DATE: {
                return LocalDate.parse(refValue, ISO_DATE_FORMATTER);
            }
            case JSONB: {
                return reference == null ? refValue : reference;
            }
        }
        throw new ClassCastException(this.getClassCastError(FieldType.REFERENCE, clientType, value));
    }

    private String getClassCastError(FieldType rdmType, DataTypeEnum clientType, Object value) {
        return String.format("Error while casting %s to %s. Value: %s", new Object[]{rdmType, clientType, value});
    }
}

