/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.change_data;

import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import ru.i_novus.ms.rdm.api.exception.RdmException;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.RdmSyncLocalRowState;
import ru.i_novus.ms.rdm.sync.util.RdmSyncDataUtils;

public abstract class RdmChangeDataRequestCallback {
    private static final Logger logger = LoggerFactory.getLogger(RdmChangeDataRequestCallback.class);
    @Autowired
    private RdmSyncDao dao;

    @Transactional
    public <T extends Serializable> void onSuccess(String refBookCode, List<? extends T> addUpdate, List<? extends T> delete) {
        this.casState(refBookCode, addUpdate, RdmSyncLocalRowState.SYNCED);
        this.onSuccess0(refBookCode, addUpdate, delete);
    }

    protected abstract <T extends Serializable> void onSuccess0(String var1, List<? extends T> var2, List<? extends T> var3);

    @Transactional
    public <T extends Serializable> void onError(String refBookCode, List<? extends T> addUpdate, List<? extends T> delete, Exception ex) {
        this.casState(refBookCode, addUpdate, RdmSyncLocalRowState.ERROR);
        this.casState(refBookCode, delete, RdmSyncLocalRowState.ERROR);
        this.onError0(refBookCode, addUpdate, delete, ex);
    }

    protected abstract <T extends Serializable> void onError0(String var1, List<? extends T> var2, List<? extends T> var3, Exception var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> void casState(String refBookCode, List<? extends T> addUpdate, RdmSyncLocalRowState state) {
        VersionMapping vm = this.dao.getVersionMapping(refBookCode, "CURRENT");
        if (vm == null) {
            return;
        }
        boolean haveTrigger = this.dao.existsInternalLocalRowStateUpdateTrigger(vm.getTable());
        String pk = vm.getPrimaryField();
        String table = vm.getTable();
        List<Object> pks = RdmSyncDataUtils.extractSnakeCaseKey(pk, addUpdate);
        if (haveTrigger) {
            this.dao.disableInternalLocalRowStateUpdateTrigger(vm.getTable());
        }
        try {
            boolean stateChanged = this.dao.setLocalRecordsState(table, pk, pks, RdmSyncLocalRowState.PENDING, state);
            if (!stateChanged) {
                logger.info("State change did not pass. Skipping callback on {}.", (Object)refBookCode);
                throw new RdmException();
            }
        }
        finally {
            if (haveTrigger) {
                this.dao.enableInternalLocalRowStateUpdateTrigger(vm.getTable());
            }
        }
    }

    public static class DefaultRdmChangeDataRequestCallback
    extends RdmChangeDataRequestCallback {
        private static final Logger logger = LoggerFactory.getLogger(DefaultRdmChangeDataRequestCallback.class);
        private static final String LOG_PULLED_SUCCESS = "Successfully pulled into RDM for refBook with code {}. Payload:\nAdded/Update objects: {},\nDeleted objects: {}";
        private static final String LOG_PULLED_FAILURE = "Error occurred while pulling data into RDM for refBook with code {}. Payload:\nattempt to Add/Update objects: {},\nattempt to Delete objects: {}";

        @Override
        public <T extends Serializable> void onSuccess0(String refBookCode, List<? extends T> addUpdate, List<? extends T> delete) {
            logger.info(LOG_PULLED_SUCCESS, new Object[]{refBookCode, addUpdate, delete});
        }

        @Override
        public <T extends Serializable> void onError0(String refBookCode, List<? extends T> addUpdate, List<? extends T> delete, Exception ex) {
            logger.error(LOG_PULLED_FAILURE, new Object[]{refBookCode, addUpdate, delete, ex});
        }
    }
}

