/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSource;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSourceDao;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.api.model.RefBookStructure;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceServiceFactory;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.service.init.LocalRefBookCreator;

public abstract class BaseLocalRefBookCreator
implements LocalRefBookCreator {
    private static final Logger logger = LoggerFactory.getLogger(BaseLocalRefBookCreator.class);
    private static final String LOG_AUTOCREATE_ERROR = "Error autocreation mapping data from structure of RefBook with code '{}'.";
    private static final String LOG_LAST_PUBLISHED_NOT_FOUND = " Can't get last published version from RDM.";
    protected static final String LOG_AUTOCREATE_SKIP = "Skip autocreation of mapping data from structure of RefBook with code '{}'.";
    protected static final String LOG_AUTOCREATE_START = "Autocreation mapping data from structure of RefBook with code '{}' is started.";
    protected final String schema;
    protected final boolean caseIgnore;
    protected final SyncSourceDao syncSourceDao;
    protected final RdmSyncDao dao;
    private final Set<SyncSourceServiceFactory> syncSourceServiceFactories;

    protected abstract void createTable(String var1, VersionMapping var2);

    public BaseLocalRefBookCreator(String schema, Boolean caseIgnore, RdmSyncDao dao, SyncSourceDao syncSourceDao, Set<SyncSourceServiceFactory> syncSourceServiceFactories) {
        this.schema = schema == null ? "rdm" : schema;
        this.caseIgnore = Boolean.TRUE.equals(caseIgnore);
        this.syncSourceDao = syncSourceDao;
        this.dao = dao;
        this.syncSourceServiceFactories = syncSourceServiceFactories;
    }

    @Override
    @Transactional
    public void create(String refBookCode, String refBookName, String source, SyncTypeEnum type, String table, String sysPkColumn, @Nullable String range) {
        if (this.dao.getVersionMapping(refBookCode, "CURRENT") != null) {
            logger.info(LOG_AUTOCREATE_SKIP, (Object)refBookCode);
            return;
        }
        logger.info(LOG_AUTOCREATE_START, (Object)refBookCode);
        VersionMapping mapping = this.createMapping(refBookCode, refBookName, source, type, table, sysPkColumn, range);
        if (!this.dao.lockRefBookForUpdate(refBookCode, true)) {
            return;
        }
        if (mapping != null) {
            this.createTable(refBookCode, mapping);
        }
    }

    protected VersionMapping createMapping(String refBookCode, String refBookName, String sourceCode, SyncTypeEnum type, String table, String sysPkColumn, @Nullable String range) {
        RefBookVersion lastPublished = this.getSyncSourceService(sourceCode).getRefBook(refBookCode, null);
        if (lastPublished == null) {
            throw new IllegalArgumentException(refBookCode + " not found in " + sourceCode);
        }
        RefBookStructure structure = lastPublished.getStructure();
        VersionMapping versionMapping = this.getVersionMapping(refBookCode, refBookName, sourceCode, type, table, structure, sysPkColumn, range);
        Integer mappingId = this.dao.insertVersionMapping(versionMapping);
        this.dao.insertFieldMapping(mappingId, this.getFieldMappings(structure));
        versionMapping.setId(mappingId);
        return versionMapping;
    }

    protected String getTableName(String refBookCode, String refBookTable) {
        Object tableName;
        String schemaName;
        if (!StringUtils.isEmpty((Object)refBookTable)) {
            String[] split = refBookTable.split("\\.");
            schemaName = split.length > 1 ? split[0] : this.schema;
            tableName = split.length > 1 ? split[1] : refBookTable;
        } else {
            schemaName = this.schema;
            tableName = refBookCode.replaceAll("[-.]", "_");
            tableName = "ref_" + (String)(this.caseIgnore ? ((String)tableName).toLowerCase() : tableName);
        }
        return String.format("%s.%s", schemaName, tableName);
    }

    protected RefBookStructure getRefBookStructure(String refBookCode, String source) {
        RefBookVersion lastPublished;
        try {
            lastPublished = this.getSyncSourceService(source).getRefBook(refBookCode, null);
        }
        catch (Exception e) {
            logger.error("Error autocreation mapping data from structure of RefBook with code '{}'. Can't get last published version from RDM.", (Object)refBookCode, (Object)e);
            return null;
        }
        return lastPublished.getStructure();
    }

    protected SyncSourceService getSyncSourceService(String sourceCode) {
        SyncSource source = this.syncSourceDao.findByCode(sourceCode);
        return this.syncSourceServiceFactories.stream().filter(factory -> factory.isSatisfied(source)).findAny().orElseThrow(() -> new IllegalArgumentException("cannot find factory by " + source.getFactoryName())).createService(source);
    }

    protected VersionMapping getVersionMapping(String refBookCode, String refBookName, String sourceCode, SyncTypeEnum type, String table, RefBookStructure structure, String sysPkColumn, @Nullable String range) {
        String uniqueSysField = this.caseIgnore ? ((String)structure.getPrimaries().get(0)).toLowerCase() : (String)structure.getPrimaries().get(0);
        String schemaTable = this.getTableName(refBookCode, table);
        return new VersionMapping(null, refBookCode, refBookName, null, schemaTable, sysPkColumn, sourceCode, uniqueSysField, null, null, -1, null, type, range);
    }

    protected List<FieldMapping> getFieldMappings(RefBookStructure structure) {
        ArrayList<FieldMapping> fieldMappings = new ArrayList<FieldMapping>(structure.getAttributesAndTypes().size() + 1);
        for (Map.Entry attr : structure.getAttributesAndTypes().entrySet()) {
            fieldMappings.add(new FieldMapping(this.caseIgnore ? ((String)attr.getKey()).toLowerCase() : (String)attr.getKey(), DataTypeEnum.getByRdmAttr((AttributeTypeEnum)attr.getValue()).getDataTypes().get(0), (String)attr.getKey()));
        }
        return fieldMappings;
    }
}

