/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.init;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSourceDao;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.RefBookStructure;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceServiceFactory;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.init.NotVersionedLocalRefBookCreator;

@Component
public class NaturalPKLocalRefBookCreator
extends NotVersionedLocalRefBookCreator {
    Logger logger = LoggerFactory.getLogger(NaturalPKLocalRefBookCreator.class);

    public NaturalPKLocalRefBookCreator(@Value(value="${rdm-sync.auto-create.schema:rdm}") String schema, @Value(value="${rdm-sync.auto-create.ignore-case:true}") Boolean caseIgnore, RdmSyncDao dao, SyncSourceDao syncSourceDao, Set<SyncSourceServiceFactory> syncSourceServiceFactories) {
        super(schema, caseIgnore, dao, syncSourceDao, syncSourceServiceFactories);
    }

    @Override
    protected void createTable(String refBookCode, VersionMapping mapping) {
        String[] split = mapping.getTable().split("\\.");
        String schemaName = split[0];
        String tableName = split[1];
        this.dao.createSchemaIfNotExists(schemaName);
        this.dao.createTableWithNaturalPrimaryKeyIfNotExists(schemaName, tableName, this.dao.getFieldMappings(refBookCode), mapping.getDeletedField(), mapping.getSysPkColumn());
        this.logger.info("Preparing table {} in schema {}.", (Object)tableName, (Object)schemaName);
        this.dao.addInternalLocalRowStateColumnIfNotExists(this.schema, tableName);
        this.dao.createOrReplaceLocalRowStateUpdateFunction();
        this.dao.addInternalLocalRowStateUpdateTrigger(this.schema, tableName);
        this.logger.info("Table {} in schema {} successfully prepared.", (Object)tableName, (Object)schemaName);
    }

    @Override
    protected VersionMapping getVersionMapping(String refBookCode, String refBookName, String sourceCode, SyncTypeEnum type, String table, RefBookStructure structure, String sysPkColumn, String range) {
        String sysPkColumnFromUniqueSysField = this.caseIgnore ? ((String)structure.getPrimaries().get(0)).toLowerCase() : (String)structure.getPrimaries().get(0);
        return super.getVersionMapping(refBookCode, refBookName, sourceCode, type, table, structure, sysPkColumnFromUniqueSysField, range);
    }
}

