/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.init;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.api.dao.SyncSourceDao;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.RefBookStructure;
import ru.i_novus.ms.rdm.sync.api.model.SyncTypeEnum;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceServiceFactory;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.init.BaseLocalRefBookCreator;

@Component
public class NotVersionedLocalRefBookCreator
extends BaseLocalRefBookCreator {
    private static final Logger logger = LoggerFactory.getLogger(NotVersionedLocalRefBookCreator.class);

    public NotVersionedLocalRefBookCreator(@Value(value="${rdm-sync.auto-create.schema:rdm}") String schema, @Value(value="${rdm-sync.auto-create.ignore-case:true}") Boolean caseIgnore, RdmSyncDao dao, SyncSourceDao syncSourceDao, Set<SyncSourceServiceFactory> syncSourceServiceFactories) {
        super(schema, caseIgnore, dao, syncSourceDao, syncSourceServiceFactories);
    }

    @Override
    protected void createTable(String refBookCode, VersionMapping mapping) {
        String[] split = mapping.getTable().split("\\.");
        String schemaName = split[0];
        String tableName = split[1];
        this.dao.createSchemaIfNotExists(schemaName);
        this.dao.createTableIfNotExists(schemaName, tableName, this.dao.getFieldMappings(mapping.getId()), mapping.getDeletedField(), mapping.getSysPkColumn());
        logger.info("Preparing table {} in schema {}.", (Object)tableName, (Object)schemaName);
        this.dao.addInternalLocalRowStateColumnIfNotExists(this.schema, tableName);
        this.dao.createOrReplaceLocalRowStateUpdateFunction();
        this.dao.addInternalLocalRowStateUpdateTrigger(this.schema, tableName);
        logger.info("Table {} in schema {} successfully prepared.", (Object)tableName, (Object)schemaName);
    }

    @Override
    protected VersionMapping getVersionMapping(String refBookCode, String refBookName, String sourceCode, SyncTypeEnum type, String table, RefBookStructure structure, String sysPkColumn, String range) {
        VersionMapping versionMapping = super.getVersionMapping(refBookCode, refBookName, sourceCode, type, table, structure, sysPkColumn, range);
        Object isDeletedField = "deleted_ts";
        if (structure.getAttributesAndTypes().containsKey(isDeletedField)) {
            isDeletedField = "rdm_sync_internal_" + (String)isDeletedField;
        }
        versionMapping.setDeletedField((String)isDeletedField);
        return versionMapping;
    }
}

