/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.init;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import ru.i_novus.ms.rdm.sync.AutoCreateRefBookProperty;
import ru.i_novus.ms.rdm.sync.api.service.SourceLoaderService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.service.RdmSyncLocalRowState;
import ru.i_novus.ms.rdm.sync.service.init.LocalRefBookCreatorLocator;
import ru.i_novus.ms.rdm.sync.service.init.RdmSyncJobConfigurer;
import ru.i_novus.ms.rdm.sync.service.init.XmlMappingLoaderService;

@Component
@DependsOn(value={"liquibaseRdm"})
public class RdmSyncInitializer {
    private static final Logger logger = LoggerFactory.getLogger(RdmSyncInitializer.class);
    @Autowired
    private XmlMappingLoaderService mappingLoaderService;
    @Autowired
    private List<SourceLoaderService> sourceLoaderServiceList;
    @Autowired
    private RdmSyncDao dao;
    @Autowired(required=false)
    private RdmSyncJobConfigurer rdmSyncJobConfigurer;
    @Autowired
    private LocalRefBookCreatorLocator localRefBookCreatorLocator;
    @Autowired
    private AutoCreateRefBookProperty autoCreateRefBookProperties;

    public void init() {
        this.sourceLoaderServiceInit();
        this.mappingLoaderService.load();
        this.autoCreate();
        if (this.rdmSyncJobConfigurer != null) {
            this.rdmSyncJobConfigurer.setupImportJob();
            this.rdmSyncJobConfigurer.setupExportJob();
        } else {
            logger.warn("Quartz scheduler is not configured. All records in the {} state will remain in it. Please, configure Quartz scheduler in clustered mode.", (Object)RdmSyncLocalRowState.DIRTY);
        }
    }

    private void autoCreate() {
        if (this.autoCreateRefBookProperties == null || this.autoCreateRefBookProperties.getRefbooks() == null) {
            return;
        }
        this.autoCreateRefBookProperties.getRefbooks().forEach(p -> this.localRefBookCreatorLocator.getLocalRefBookCreator(p.getType()).create(p.getCode(), p.getName(), p.getSource(), p.getType(), p.getTable(), p.getSysPkColumn(), p.getRange()));
    }

    private void sourceLoaderServiceInit() {
        this.sourceLoaderServiceList.forEach(SourceLoaderService::load);
    }
}

